/********************************************************************************
 * Copyright (C) 2018 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { ContributionProvider } from '../common/contribution-provider';
import { FrontendApplicationContribution } from './frontend-application';
import { MaybePromise } from '../common';
import { Deferred } from '../common/promise-util';
export interface JsonSchemaConfiguration {
    fileMatch: string | string[];
    url: string;
}
export interface JsonSchemaRegisterContext {
    registerSchema(config: JsonSchemaConfiguration): void;
}
export declare const JsonSchemaContribution: unique symbol;
export interface JsonSchemaContribution {
    registerSchemas(store: JsonSchemaRegisterContext): MaybePromise<void>;
}
export declare class JsonSchemaStore implements FrontendApplicationContribution {
    protected readonly contributions: ContributionProvider<JsonSchemaContribution>;
    protected readonly _schemas: Deferred<JsonSchemaConfiguration[]>;
    get schemas(): Promise<JsonSchemaConfiguration[]>;
    onStart(): void;
    protected getRegisterTimeout(): number;
}
export declare class DefaultJsonSchemaContribution implements JsonSchemaContribution {
    registerSchemas(context: JsonSchemaRegisterContext): Promise<void>;
}
export declare namespace DefaultJsonSchemaContribution {
    interface SchemaData {
        name: string;
        description: string;
        fileMatch?: string[];
        url: string;
        schema: any;
    }
}
//# sourceMappingURL=json-schema-store.d.ts.map