/********************************************************************************
 * Copyright (C) 2018 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { interfaces } from 'inversify';
import { JsonRpcProxy, Emitter, Event, MessageService } from '../../common';
import { WebSocketChannel } from '../../common/messaging/web-socket-channel';
import ReconnectingWebSocket from 'reconnecting-websocket';
import { AbstractConnectionProvider } from '../../common/messaging/abstract-connection-provider';
export interface WebSocketOptions {
    /**
     * True by default.
     */
    reconnecting?: boolean;
}
export declare const HttpFallbackOptions: unique symbol;
export interface HttpFallbackOptions {
    /** Determines whether Theia is allowed to use the http fallback. True by default. */
    allowed: boolean;
    /** Number of failed websocket connection attempts before the fallback is triggered. 2 by default. */
    maxAttempts: number;
    /** The maximum duration (in ms) after which the http request should timeout. 5000 by default. */
    pollingTimeout: number;
    /** The timeout duration (in ms) after a request was answered with an error code. 5000 by default. */
    errorTimeout: number;
    /** The minimum timeout duration (in ms) between two http requests. 0 by default. */
    requestTimeout: number;
}
export declare const DEFAULT_HTTP_FALLBACK_OPTIONS: HttpFallbackOptions;
export declare class WebSocketConnectionProvider extends AbstractConnectionProvider<WebSocketOptions> {
    protected readonly onSocketDidOpenEmitter: Emitter<void>;
    readonly onSocketDidOpen: Event<void>;
    protected readonly onSocketDidCloseEmitter: Emitter<void>;
    readonly onSocketDidClose: Event<void>;
    protected readonly onHttpFallbackDidActivateEmitter: Emitter<void>;
    readonly onHttpFallbackDidActivate: Event<void>;
    static createProxy<T extends object>(container: interfaces.Container, path: string, arg?: object): JsonRpcProxy<T>;
    protected readonly messageService: () => MessageService;
    protected readonly httpFallbackOptions: HttpFallbackOptions | undefined;
    protected readonly socket: ReconnectingWebSocket;
    protected useHttpFallback: boolean;
    protected websocketErrorCounter: number;
    protected httpFallbackId: string;
    protected httpFallbackDisconnected: boolean;
    constructor();
    handleSocketError(event: unknown): void;
    doLongPolling(url: string): Promise<void>;
    openChannel(path: string, handler: (channel: WebSocketChannel) => void, options?: WebSocketOptions): void;
    protected createChannel(id: number): WebSocketChannel;
    /**
     * Creates a websocket URL to the current location
     */
    protected createWebSocketUrl(path: string): string;
    protected createHttpWebSocketUrl(path: string): string;
    /**
     * Creates a web socket for the given url
     */
    protected createWebSocket(url: string): ReconnectingWebSocket;
    protected fireSocketDidOpen(): void;
    protected fireSocketDidClose(): void;
    protected tryReconnect(): void;
}
//# sourceMappingURL=ws-connection-provider.d.ts.map