/********************************************************************************
 * Copyright (C) 2018 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { interfaces } from 'inversify';
import { ContributionProvider, Emitter, Event, Disposable } from '../../common';
import { PreferenceScope } from './preference-scope';
import { PreferenceProvider, PreferenceProviderDataChange } from './preference-provider';
import { PreferenceSchema, PreferenceSchemaProperties, PreferenceDataSchema, PreferenceItem, PreferenceSchemaProperty, PreferenceDataProperty, JsonType } from '../../common/preferences/preference-schema';
import { FrontendApplicationConfig } from '@theia/application-package/lib/application-props';
import { PreferenceConfigurations } from './preference-configurations';
export { PreferenceSchema, PreferenceSchemaProperties, PreferenceDataSchema, PreferenceItem, PreferenceSchemaProperty, PreferenceDataProperty, JsonType };
import { OverridePreferenceName } from './preference-language-override-service';
/**
 * @deprecated since 1.13.0 import from @theia/core/lib/browser/preferences/preference-language-override-service.
 */
export { OVERRIDE_PROPERTY_PATTERN } from './preference-language-override-service';
export declare const PreferenceContribution: unique symbol;
/**
 * A {@link PreferenceContribution} allows adding additional custom preferences.
 * For this, the {@link PreferenceContribution} has to provide a valid JSON Schema specifying which preferences
 * are available including their types and description.
 *
 * ### Example usage
 * ```typescript
 * const MyPreferencesSchema: PreferenceSchema = {
 *     'type': 'object',
 *     'properties': {
 *         'myext.decorations.enabled': {
 *             'type': 'boolean',
 *             'description': 'Show file status',
 *             'default': true
 *         },
 *         // [...]
 *     }
 * }
 * @injectable()
 * export class MyPreferenceContribution implements PreferenceContribution{
 *     schema= MyPreferencesSchema;
 * }
 * ```
 */
export interface PreferenceContribution {
    readonly schema: PreferenceSchema;
}
export declare function bindPreferenceSchemaProvider(bind: interfaces.Bind): void;
/**
 * Specialized {@link FrontendApplicationConfig} to configure default
 * preference values for the {@link PreferenceSchemaProvider}.
 */
export interface FrontendApplicationPreferenceConfig extends FrontendApplicationConfig {
    preferences: {
        [preferenceName: string]: any;
    };
}
export declare namespace FrontendApplicationPreferenceConfig {
    function is(config: FrontendApplicationConfig): config is FrontendApplicationPreferenceConfig;
}
/**
 * The {@link PreferenceSchemaProvider} collects all {@link PreferenceContribution}s and combines
 * the preference schema provided by these contributions into one collective schema. The preferences which
 * are provided by this {@link PreferenceProvider} are derived from this combined schema.
 */
export declare class PreferenceSchemaProvider extends PreferenceProvider {
    protected readonly preferences: {
        [name: string]: any;
    };
    protected readonly combinedSchema: PreferenceDataSchema;
    protected readonly workspaceSchema: PreferenceDataSchema;
    protected readonly folderSchema: PreferenceDataSchema;
    protected readonly preferenceContributions: ContributionProvider<PreferenceContribution>;
    protected readonly configurations: PreferenceConfigurations;
    protected readonly onDidPreferenceSchemaChangedEmitter: Emitter<void>;
    readonly onDidPreferenceSchemaChanged: Event<void>;
    protected fireDidPreferenceSchemaChanged(): void;
    protected init(): void;
    /**
     * Register a new overrideIdentifier. Existing identifiers are not replaced.
     *
     * Allows overriding existing values while keeping both values in store.
     * For example to store different editor settings, e.g. "[markdown].editor.autoIndent",
     * "[json].editor.autoIndent" and "editor.autoIndent"
     * @param overrideIdentifier the new overrideIdentifier
     */
    registerOverrideIdentifier(overrideIdentifier: string): void;
    protected readonly overridePatternProperties: Required<Pick<PreferenceDataProperty, 'properties' | 'additionalProperties'>> & PreferenceDataProperty;
    protected overridePatternPropertiesKey: string | undefined;
    protected updateOverridePatternPropertiesKey(): void;
    protected doUnsetSchema(changes: PreferenceProviderDataChange[]): PreferenceProviderDataChange[];
    protected doSetSchema(schema: PreferenceSchema): PreferenceProviderDataChange[];
    protected doSetPreferenceValue(preferenceName: string, newValue: any, { scope, domain }: {
        scope: PreferenceScope;
        domain?: string[];
    }): PreferenceProviderDataChange;
    protected getDefaultValue(property: PreferenceItem): any;
    protected getConfiguredDefault(preferenceName: string): any;
    getCombinedSchema(): PreferenceDataSchema;
    getSchema(scope: PreferenceScope): PreferenceDataSchema;
    setSchema(schema: PreferenceSchema): Disposable;
    getPreferences(): {
        [name: string]: any;
    };
    setPreference(): Promise<boolean>;
    isValidInScope(preferenceName: string, scope: PreferenceScope): boolean;
    getPreferenceNames(): IterableIterator<string>;
    getOverridePreferenceNames(preferenceName: string): IterableIterator<string>;
    protected updateSchemaProps(key: string, property: PreferenceDataProperty): void;
    protected removePropFromSchemas(key: string): void;
    protected readConfiguredPreferences(): void;
    /**
     * @deprecated since 1.13.0 use `PreferenceLanguageOverrideService.overridePreferenceName`
     */
    overridePreferenceName(override: OverridePreferenceName): string;
    /**
     * @deprecated since 1.13.0 use `PreferenceLanguageOverrideService.testOverrideValue`
     */
    testOverrideValue(name: string, value: any): value is PreferenceSchemaProperties;
    /**
     * @deprecated since 1.13.0 use `PreferenceLanguageOverrideService.overriddenPreferenceName`
     */
    overriddenPreferenceName(name: string): OverridePreferenceName | undefined;
}
//# sourceMappingURL=preference-contribution.d.ts.map