/********************************************************************************
 * Copyright (c) 2021 SAP SE or an SAP affiliate company and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { KeybindingRegistry } from '../keybinding';
import { Disposable, Command, CommandRegistry, CancellationToken } from '../../common';
import { ContextKeyService } from '../context-key-service';
import { CorePreferences } from '../core-preferences';
import { QuickAccessContribution, QuickAccessProvider, QuickAccessRegistry } from './quick-access';
import { QuickPicks } from './quick-input-service';
export declare const quickCommand: Command;
export declare const CLEAR_COMMAND_HISTORY: Command;
export declare class QuickCommandService implements QuickAccessContribution, QuickAccessProvider {
    static PREFIX: string;
    protected readonly contextKeyService: ContextKeyService;
    protected readonly commandRegistry: CommandRegistry;
    protected readonly corePreferences: CorePreferences;
    protected readonly quickAccessRegistry: QuickAccessRegistry;
    protected readonly keybindingRegistry: KeybindingRegistry;
    readonly exemptedCommands: Command[];
    private recentItems;
    private otherItems;
    registerQuickAccessProvider(): void;
    reset(): void;
    getPicks(filter: string, token: CancellationToken): QuickPicks;
    private toItem;
    private getKeybinding;
    private getItemIconClasses;
    protected readonly contexts: Map<string, string[]>;
    pushCommandContext(commandId: string, when: string): Disposable;
    /**
     * Get the list of valid commands.
     *
     * @param commands the list of raw commands.
     * @returns the list of valid commands.
     */
    protected getValidCommands(raw: Command[]): Command[];
    /**
     * Get the list of recently used and other commands.
     *
     * @returns the list of recently used commands and other commands.
     */
    protected getCommands(): {
        recent: Command[];
        other: Command[];
    };
    /**
     * Normalizes a list of commands.
     * Normalization includes obtaining commands that have labels, are visible, and are enabled.
     *
     * @param commands the list of commands.
     * @returns the list of normalized commands.
     */
    private normalize;
    /**
     * Sorts a list of commands alphabetically.
     *
     * @param commands the list of commands.
     * @returns the list of sorted commands.
     */
    private sort;
}
//# sourceMappingURL=quick-command-service.d.ts.map