/********************************************************************************
 * Copyright (c) 2021 SAP SE or an SAP affiliate company and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { CancellationToken } from '../../common';
import { QuickAccessContribution, QuickAccessProvider, QuickAccessRegistry } from './quick-access';
import { QuickInputService, QuickPickItem, QuickPickSeparator } from './quick-input-service';
export declare class QuickHelpService implements QuickAccessProvider, QuickAccessContribution {
    static PREFIX: string;
    protected quickAccessRegistry: QuickAccessRegistry;
    protected quickInputService: QuickInputService;
    getPicks(filter: string, token: CancellationToken): (QuickPickItem | QuickPickSeparator)[];
    private getQuickAccessProviders;
    registerQuickAccessProvider(): void;
}
//# sourceMappingURL=quick-help-service.d.ts.map