/********************************************************************************
 * Copyright (c) 2021 SAP SE or an SAP affiliate company and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { QuickPickItem, QuickPicks } from '..';
import { CancellationToken, Disposable } from '../../common';
import { ContextKeyService } from '../context-key-service';
import { QuickAccessContribution, QuickAccessProvider, QuickAccessRegistry } from './quick-access';
export interface QuickViewItem {
    readonly label: string;
    readonly when?: string;
    readonly open: () => void;
}
export declare class QuickViewService implements QuickAccessContribution, QuickAccessProvider {
    static PREFIX: string;
    protected readonly items: (QuickPickItem & {
        when?: string;
    })[];
    private hiddenItemLabels;
    protected readonly quickAccessRegistry: QuickAccessRegistry;
    protected readonly contextKexService: ContextKeyService;
    registerItem(item: QuickViewItem): Disposable;
    hideItem(label: string): void;
    showItem(label: string): void;
    registerQuickAccessProvider(): void;
    getPicks(filter: string, token: CancellationToken): QuickPicks;
}
//# sourceMappingURL=quick-view-service.d.ts.map