/********************************************************************************
 * Copyright (C) 2021 Arm and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import * as React from 'react';
import { ReactRenderer, RendererHost } from './widgets/react-renderer';
import { CorePreferences } from './core-preferences';
import { DisposableCollection } from '../common/disposable';
export declare const TooltipService: unique symbol;
export interface TooltipService {
    tooltipId: string;
    attachTo(host: HTMLElement): void;
    update(fullRender?: boolean): void;
}
/**
 * Attributes to be added to an HTML element to enable
 * rich HTML tooltip rendering
 */
export interface TooltipAttributes {
    /**
     * HTML to render in the tooltip.
     */
    'data-tip': string;
    /**
     * The ID of the tooltip renderer. Should be TOOLTIP_ID.
     */
    'data-for': string;
}
export declare class TooltipServiceImpl extends ReactRenderer implements TooltipService {
    protected readonly corePreferences: CorePreferences;
    readonly tooltipId: string;
    protected rendered: boolean;
    protected toDispose: DisposableCollection;
    constructor(host?: RendererHost);
    protected init(): void;
    attachTo(host: HTMLElement): void;
    update(fullRender?: boolean): void;
    protected doRender(): React.ReactNode;
    dispose(): void;
}
//# sourceMappingURL=tooltip-service.d.ts.map