/********************************************************************************
 * Copyright (C) 2020 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { IpcMainEvent, WebContents } from '../../../shared/electron';
import { MessageConnection } from 'vscode-ws-jsonrpc';
import { ContributionProvider } from '../../common/contribution-provider';
import { WebSocketChannel } from '../../common/messaging/web-socket-channel';
import { MessagingContribution } from '../../node/messaging/messaging-contribution';
import { ElectronConnectionHandler } from '../../electron-common/messaging/electron-connection-handler';
import { ElectronMainApplicationContribution } from '../electron-main-application';
import { ElectronMessagingService } from './electron-messaging-service';
/**
 * This component replicates the role filled by `MessagingContribution` but for Electron.
 * Unlike the WebSocket based implementation, we do not expect to receive
 * connection events. Instead, we'll create channels based on incoming `open`
 * events on the `ipcMain` channel.
 *
 * This component allows communication between renderer process (frontend) and electron main process.
 */
export declare class ElectronMessagingContribution implements ElectronMainApplicationContribution, ElectronMessagingService {
    protected readonly messagingContributions: ContributionProvider<ElectronMessagingService.Contribution>;
    protected readonly connectionHandlers: ContributionProvider<ElectronConnectionHandler>;
    protected readonly channelHandlers: MessagingContribution.ConnectionHandlers<WebSocketChannel>;
    protected readonly windowChannels: Map<number, Map<number, WebSocketChannel>>;
    protected init(): void;
    onStart(): void;
    listen(spec: string, callback: (params: ElectronMessagingService.PathParams, connection: MessageConnection) => void): void;
    ipcChannel(spec: string, callback: (params: any, channel: WebSocketChannel) => void): void;
    protected handleIpcMessage(event: IpcMainEvent, data: string): void;
    protected createChannel(id: number, sender: WebContents): WebSocketChannel;
}
//# sourceMappingURL=electron-messaging-contribution.d.ts.map