/********************************************************************************
 * Copyright (C) 2021 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import * as ws from 'ws';
import { CancellationTokenSource } from '../../common';
import { Deferred } from '../../common/promise-util';
export declare const HttpWebsocketAdapterFactory: unique symbol;
export declare const HttpWebsocketAdapterTimeout: unique symbol;
export declare const DEFAULT_HTTP_WEBSOCKET_ADAPTER_TIMEOUT = 4000;
export declare class HttpWebsocketAdapter {
    protected readonly adapterTimeout: number;
    readyState: number;
    alive: boolean;
    protected pendingTimeout?: CancellationTokenSource;
    protected pendingMessages: unknown[];
    protected deferredMessageHandler: Deferred<unknown[]>;
    getPendingMessages(): Promise<unknown[]>;
    protected _onerror: (error: Error) => void;
    protected _onclose: (code?: number, reason?: string) => void;
    protected _onmessage: (data: string) => void;
    onerror(error: Error): void;
    onclose(code?: number, reason?: string): void;
    onmessage(data: string): void;
    send(data: unknown): void;
    on(event: 'close', listener: (this: WebSocket, code?: number, reason?: string) => void): this;
    on(event: 'error', listener: (this: WebSocket, err: Error) => void): this;
    on(event: 'message', listener: (this: WebSocket, data: ws.Data) => void): this;
}
//# sourceMappingURL=http-websocket-adapter.d.ts.map