/********************************************************************************
 * Copyright (C) 2018 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
/// <reference types="@theia/monaco-editor-core/monaco" />
/// <reference types="@theia/monaco/src/typings/monaco/index" />
/// <reference types="lodash" />
import { DebugProtocol } from 'vscode-debugprotocol/lib/debugProtocol';
import { ConsoleSession, ConsoleItem } from '@theia/console/lib/browser/console-session';
import { DebugSession } from '../debug-session';
import URI from '@theia/core/lib/common/uri';
export declare const DebugConsoleSessionFactory: unique symbol;
export declare type DebugConsoleSessionFactory = (debugSession: DebugSession) => DebugConsoleSession;
export declare class DebugConsoleSession extends ConsoleSession {
    static uri: URI;
    protected items: ConsoleItem[];
    protected _debugSession: DebugSession;
    protected uncompletedItemContent: string | undefined;
    protected readonly completionKinds: Map<"function" | "value" | "module" | "text" | "file" | "color" | "method" | "constructor" | "field" | "variable" | "class" | "interface" | "property" | "unit" | "enum" | "keyword" | "snippet" | "reference" | "customcolor" | undefined, monaco.languages.CompletionItemKind>;
    get debugSession(): DebugSession;
    set debugSession(value: DebugSession);
    init(): void;
    getElements(): IterableIterator<ConsoleItem>;
    protected completions(model: monaco.editor.ITextModel, position: monaco.Position): Promise<monaco.languages.CompletionList | undefined>;
    protected asCompletionItem(text: string, position: monaco.Position, overwriteBefore: number, item: DebugProtocol.CompletionItem): monaco.languages.CompletionItem;
    execute(value: string): Promise<void>;
    clear(): void;
    append(value: string): void;
    appendLine(value: string): void;
    logOutput(session: DebugSession, event: DebugProtocol.OutputEvent): Promise<void>;
    protected fireDidChange: import("lodash").DebouncedFunc<() => void>;
}
//# sourceMappingURL=debug-console-session.d.ts.map