/********************************************************************************
 * Copyright (c) 2021 SAP SE or an SAP affiliate company and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { DebugProtocol } from 'vscode-debugprotocol';
import { DebugSessionConnection } from './debug-session-connection';
export declare const DebugContribution: unique symbol;
export interface DebugContribution {
    register(configType: string, connection: DebugSessionConnection): void;
}
export interface DebugPluginConfiguration {
    debugMode?: string;
    pluginLocation?: string;
    debugPort?: string;
}
export interface LaunchVSCodeRequest extends DebugProtocol.Request {
    arguments: LaunchVSCodeArguments;
}
export interface LaunchVSCodeArguments {
    args: LaunchVSCodeArgument[];
    env?: {
        [key: string]: string | null;
    };
}
export interface LaunchVSCodeArgument {
    prefix?: string;
    path?: string;
}
export interface LaunchVSCodeResult {
    rendererDebugPort?: number;
}
//# sourceMappingURL=debug-contribution.d.ts.map