/********************************************************************************
 * Copyright (C) 2018 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { JsonSchemaRegisterContext, JsonSchemaContribution } from '@theia/core/lib/browser/json-schema-store';
import { InMemoryResources } from '@theia/core/lib/common';
import URI from '@theia/core/lib/common/uri';
import { DebugService } from '../common/debug-service';
import { WorkspaceService } from '@theia/workspace/lib/browser';
export declare class DebugSchemaUpdater implements JsonSchemaContribution {
    protected readonly uri: URI;
    protected readonly inmemoryResources: InMemoryResources;
    protected readonly workspaceService: WorkspaceService;
    protected readonly debug: DebugService;
    protected init(): void;
    registerSchemas(context: JsonSchemaRegisterContext): void;
    update(): Promise<void>;
}
export declare const launchSchemaId = "vscode://schemas/launch";
//# sourceMappingURL=debug-schema-updater.d.ts.map