/********************************************************************************
 * Copyright (C) 2020 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
/// <reference types="@theia/monaco-editor-core/monaco" />
/// <reference types="@theia/monaco/src/typings/monaco/index" />
import { FrontendApplicationContribution } from '@theia/core/lib/browser/frontend-application';
import { MonacoEditorService } from '@theia/monaco/lib/browser/monaco-editor-service';
import { DebugPreferences } from '../debug-preferences';
import { DebugEditorModel } from './debug-editor-model';
import { DebugStackFrame } from '../model/debug-stack-frame';
export declare const INLINE_VALUE_DECORATION_KEY = "inlinevaluedecoration";
export declare class DebugInlineValueDecorator implements FrontendApplicationContribution {
    protected readonly editorService: MonacoEditorService;
    protected readonly preferences: DebugPreferences;
    protected enabled: boolean;
    protected wordToLineNumbersMap: Map<string, monaco.Position[]> | undefined;
    onStart(): void;
    calculateDecorations(debugEditorModel: DebugEditorModel, stackFrame: DebugStackFrame | undefined): Promise<monaco.editor.IDecorationOptions[]>;
    protected updateInlineValueDecorations(model: monaco.editor.ITextModel | undefined, stackFrame: DebugStackFrame | undefined): Promise<monaco.editor.IDecorationOptions[]>;
    private createInlineValueDecorationsInsideRange;
    private createInlineValueDecoration;
    private getWordToPositionsMap;
}
//# sourceMappingURL=debug-inline-value-decorator.d.ts.map