"use strict";
/********************************************************************************
 * Copyright (C) 2018 Red Hat, Inc. and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DebugToolBar = void 0;
const React = require("@theia/core/shared/react");
const inversify_1 = require("@theia/core/shared/inversify");
const core_1 = require("@theia/core");
const widgets_1 = require("@theia/core/lib/browser/widgets");
const debug_view_model_1 = require("./debug-view-model");
const debug_session_1 = require("../debug-session");
const debug_action_1 = require("./debug-action");
let DebugToolBar = class DebugToolBar extends widgets_1.ReactWidget {
    constructor() {
        super(...arguments);
        this.setStepRef = (stepRef) => this.stepRef = stepRef || undefined;
        this.start = () => this.model.start();
        this.restart = () => this.model.restart();
        this.stop = () => this.model.terminate();
        this.continue = () => this.model.currentThread && this.model.currentThread.continue();
        this.pause = () => this.model.currentThread && this.model.currentThread.pause();
        this.stepOver = () => this.model.currentThread && this.model.currentThread.stepOver();
        this.stepIn = () => this.model.currentThread && this.model.currentThread.stepIn();
        this.stepOut = () => this.model.currentThread && this.model.currentThread.stepOut();
    }
    init() {
        this.id = 'debug:toolbar:' + this.model.id;
        this.addClass('debug-toolbar');
        this.toDispose.push(this.model);
        this.toDispose.push(this.model.onDidChange(() => this.update()));
        this.scrollOptions = undefined;
        this.update();
    }
    focus() {
        if (!this.doFocus()) {
            this.onRender.push(core_1.Disposable.create(() => this.doFocus()));
            this.update();
        }
    }
    doFocus() {
        if (!this.stepRef) {
            return false;
        }
        this.stepRef.focus();
        return true;
    }
    render() {
        const { state } = this.model;
        return React.createElement(React.Fragment, null,
            this.renderContinue(),
            React.createElement(debug_action_1.DebugAction, { enabled: state === debug_session_1.DebugState.Stopped, run: this.stepOver, label: 'Step Over', iconClass: 'debug-step-over', ref: this.setStepRef }),
            React.createElement(debug_action_1.DebugAction, { enabled: state === debug_session_1.DebugState.Stopped, run: this.stepIn, label: 'Step Into', iconClass: 'debug-step-into' }),
            React.createElement(debug_action_1.DebugAction, { enabled: state === debug_session_1.DebugState.Stopped, run: this.stepOut, label: 'Step Out', iconClass: 'debug-step-out' }),
            React.createElement(debug_action_1.DebugAction, { enabled: state !== debug_session_1.DebugState.Inactive, run: this.restart, label: 'Restart', iconClass: 'debug-restart' }),
            this.renderStart());
    }
    renderStart() {
        const { state } = this.model;
        if (state === debug_session_1.DebugState.Inactive && this.model.sessionCount === 1) {
            return React.createElement(debug_action_1.DebugAction, { run: this.start, label: 'Start', iconClass: 'debug-start' });
        }
        return React.createElement(debug_action_1.DebugAction, { enabled: state !== debug_session_1.DebugState.Inactive, run: this.stop, label: 'Stop', iconClass: 'debug-stop' });
    }
    renderContinue() {
        const { state } = this.model;
        if (state === debug_session_1.DebugState.Stopped) {
            return React.createElement(debug_action_1.DebugAction, { run: this.continue, label: 'Continue', iconClass: 'debug-continue' });
        }
        return React.createElement(debug_action_1.DebugAction, { enabled: state === debug_session_1.DebugState.Running, run: this.pause, label: 'Pause', iconClass: 'debug-pause' });
    }
};
__decorate([
    inversify_1.inject(debug_view_model_1.DebugViewModel),
    __metadata("design:type", debug_view_model_1.DebugViewModel)
], DebugToolBar.prototype, "model", void 0);
__decorate([
    inversify_1.postConstruct(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], DebugToolBar.prototype, "init", null);
DebugToolBar = __decorate([
    inversify_1.injectable()
], DebugToolBar);
exports.DebugToolBar = DebugToolBar;
//# sourceMappingURL=debug-toolbar-widget.js.map