/********************************************************************************
 * Copyright (C) 2021 Red Hat, Inc. and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { Event } from '@theia/core/lib/common/event';
import { CommunicationProvider } from './debug-model';
import * as theia from '@theia/plugin';
/**
 * A communication provider for using the inline implementation of a debug adapter.
 */
export declare class InlineCommunicationProvider implements CommunicationProvider {
    private debugAdapter;
    private messageReceivedEmitter;
    onMessageReceived: Event<string>;
    onError: Event<Error>;
    private closeEmitter;
    onClose: Event<void>;
    constructor(debugAdapter: theia.DebugAdapter);
    send(message: string): void;
    dispose(): void;
}
//# sourceMappingURL=inline-communication-provider.d.ts.map