/********************************************************************************
 * Copyright (C) 2021 Red Hat, Inc. and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
/// <reference types="node" />
import { DisposableCollection } from '@theia/core/lib/common/disposable';
import { Event } from '@theia/core/lib/common/event';
import * as stream from 'stream';
import { CommunicationProvider } from './debug-model';
export declare class StreamCommunicationProvider extends DisposableCollection implements CommunicationProvider {
    private fromAdapter;
    private toAdapter;
    private messageReceivedEmitter;
    onMessageReceived: Event<string>;
    private errorEmitter;
    onError: Event<Error>;
    private closeEmitter;
    onClose: Event<void>;
    private static TWO_CRLF;
    private static CONTENT_LENGTH;
    private contentLength;
    private buffer;
    constructor(fromAdapter: stream.Readable, toAdapter: stream.Writable);
    send(message: string): void;
    protected handleData(data: Buffer): void;
}
//# sourceMappingURL=stream-communication-provider.d.ts.map