/********************************************************************************
 * Copyright (C) 2018-2021 Google and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { EditorManager, EditorOpenerOptions, EditorWidget } from '@theia/editor/lib/browser';
import { EditorPreviewPreferences } from './editor-preview-preferences';
import { DisposableCollection, MaybePromise } from '@theia/core/lib/common';
import URI from '@theia/core/lib/common/uri';
import { EditorPreviewOptions } from './editor-preview-widget-factory';
import { EditorPreviewWidget } from './editor-preview-widget';
import { FrontendApplicationStateService } from '@theia/core/lib/browser/frontend-application-state';
export declare class EditorPreviewManager extends EditorManager {
    readonly id: string;
    protected readonly preferences: EditorPreviewPreferences;
    protected readonly stateService: FrontendApplicationStateService;
    protected currentPreview: EditorPreviewWidget | undefined;
    protected toDisposeOnPreviewChange: DisposableCollection;
    /**
     * Until the layout has been restored, widget state is not reliable, so we ignore creation events.
     */
    protected layoutIsSet: boolean;
    protected init(): void;
    protected doOpen(widget: EditorPreviewWidget, options?: EditorOpenerOptions): Promise<void>;
    protected handleNewPreview(widget: EditorPreviewWidget): void;
    protected tryGetPendingWidget(uri: URI, options?: EditorOpenerOptions): MaybePromise<EditorWidget> | undefined;
    protected getWidget(uri: URI, options?: EditorOpenerOptions): Promise<EditorWidget | undefined>;
    protected getOrCreateWidget(uri: URI, options?: EditorOpenerOptions): Promise<EditorWidget>;
    protected createWidgetOptions(uri: URI, options?: EditorOpenerOptions): EditorPreviewOptions;
    protected convertEditorOnDoubleClick(event: Event): void;
}
//# sourceMappingURL=editor-preview-manager.d.ts.map