/********************************************************************************
 * Copyright (C) 2021 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { TreeDecorator, TreeDecoration } from '@theia/core/lib/browser/tree/tree-decorator';
import { Emitter } from '@theia/core/lib/common/event';
import { Tree } from '@theia/core/lib/browser/tree/tree';
import { ApplicationShell, FrontendApplication, FrontendApplicationContribution, NavigatableWidget, Widget } from '@theia/core/lib/browser';
import { Disposable } from '@theia/core/lib/common';
import { EditorPreviewManager } from './editor-preview-manager';
export declare class EditorPreviewTreeDecorator implements TreeDecorator, FrontendApplicationContribution {
    protected readonly editorPreviewManager: EditorPreviewManager;
    protected readonly shell: ApplicationShell;
    readonly id = "theia-open-editors-file-decorator";
    protected decorationsMap: Map<string, TreeDecoration.Data>;
    protected readonly decorationsChangedEmitter: Emitter<any>;
    readonly onDidChangeDecorations: import("@theia/core").Event<any>;
    protected readonly toDisposeOnDirtyChanged: Map<string, Disposable>;
    protected readonly toDisposeOnPreviewPinned: Map<string, Disposable>;
    onDidInitializeLayout(app: FrontendApplication): void;
    protected registerEditorListeners(widget: Widget): void;
    protected unregisterEditorListeners(widget: Widget): void;
    protected get editorWidgets(): NavigatableWidget[];
    protected fireDidChangeDecorations(event: (tree: Tree) => Map<string, TreeDecoration.Data>): void;
    decorations(tree: Tree): Map<string, TreeDecoration.Data>;
    protected collectDecorators(tree: Tree): Map<string, TreeDecoration.Data>;
}
//# sourceMappingURL=editor-preview-tree-decorator.d.ts.map