/********************************************************************************
 * Copyright (C) 2018-2021 Google and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import URI from '@theia/core/lib/common/uri';
import { EditorWidgetFactory } from '@theia/editor/lib/browser/editor-widget-factory';
import { EditorPreviewWidget } from './editor-preview-widget';
import { NavigatableWidgetOptions } from '@theia/core/lib/browser';
export interface EditorPreviewOptions extends NavigatableWidgetOptions {
    preview?: boolean;
}
export declare class EditorPreviewWidgetFactory extends EditorWidgetFactory {
    static ID: string;
    readonly id: string;
    createWidget(options: EditorPreviewOptions): Promise<EditorPreviewWidget>;
    protected constructEditor(uri: URI): Promise<EditorPreviewWidget>;
}
//# sourceMappingURL=editor-preview-widget-factory.d.ts.map