/********************************************************************************
 * Copyright (C) 2021 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { Message } from '@theia/core/shared/@phosphor/messaging';
import { TabBar, Widget } from '@theia/core/lib/browser';
import { EditorWidget, TextEditor } from '@theia/editor/lib/browser';
import { DisposableCollection, Emitter, SelectionService } from '@theia/core/lib/common';
export declare class EditorPreviewWidget extends EditorWidget {
    readonly editor: TextEditor;
    protected readonly selectionService: SelectionService;
    protected _isPreview: boolean;
    protected lastTabbar: TabBar<Widget> | undefined;
    protected readonly onDidChangePreviewStateEmitter: Emitter<void>;
    readonly onDidChangePreviewState: import("@theia/core").Event<void>;
    protected readonly toDisposeOnLocationChange: DisposableCollection;
    get isPreview(): boolean;
    constructor(editor: TextEditor, selectionService: SelectionService);
    initializePreview(): void;
    convertToNonPreview(): void;
    protected onAfterAttach(msg: Message): void;
    protected checkForTabbarChange(): void;
    storeState(): {
        isPreview: boolean;
        editorState: object;
    };
    restoreState(oldState: {
        isPreview: boolean;
        editorState: object;
    }): void;
}
//# sourceMappingURL=editor-preview-widget.d.ts.map