/********************************************************************************
 * Copyright (C) 2017 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { EditorManager } from './editor-manager';
import { TextEditor } from './editor';
import { StatusBar } from '@theia/core/lib/browser/status-bar/status-bar';
import { FrontendApplicationContribution, QuickInputService, KeybindingRegistry, KeybindingContribution } from '@theia/core/lib/browser';
import { ContextKeyService } from '@theia/core/lib/browser/context-key-service';
import { DisposableCollection } from '@theia/core';
import { CommandRegistry, CommandContribution } from '@theia/core/lib/common';
import { LanguageService } from '@theia/core/lib/browser/language-service';
export declare class EditorContribution implements FrontendApplicationContribution, CommandContribution, KeybindingContribution {
    protected readonly statusBar: StatusBar;
    protected readonly editorManager: EditorManager;
    protected readonly languages: LanguageService;
    protected readonly contextKeyService: ContextKeyService;
    protected readonly quickInputService: QuickInputService;
    onStart(): void;
    protected initEditorContextKeys(): void;
    protected readonly toDisposeOnCurrentEditorChanged: DisposableCollection;
    protected updateStatusBar(): void;
    protected updateLanguageStatus(editor: TextEditor | undefined): void;
    protected updateEncodingStatus(editor: TextEditor | undefined): void;
    protected setCursorPositionStatus(editor: TextEditor | undefined): void;
    registerCommands(commands: CommandRegistry): void;
    registerKeybindings(keybindings: KeybindingRegistry): void;
}
//# sourceMappingURL=editor-contribution.d.ts.map