/********************************************************************************
 * Copyright (c) 2021 SAP SE or an SAP affiliate company and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { CancellationToken } from '@theia/core/lib/common';
import URI from '@theia/core/lib/common/uri';
import { LabelProvider } from '@theia/core/lib/browser/label-provider';
import { OpenerService } from '@theia/core/lib/browser/opener-service';
import { QuickAccessProvider, QuickAccessRegistry, QuickAccessContribution } from '@theia/core/lib/browser/quick-input/quick-access';
import { QuickPickItem, QuickPickSeparator } from '@theia/core/lib/browser/quick-input/quick-input-service';
import { EditorManager } from '.';
export declare class QuickEditorService implements QuickAccessContribution, QuickAccessProvider {
    static PREFIX: string;
    protected readonly openerService: OpenerService;
    protected readonly labelProvider: LabelProvider;
    protected readonly quickAccessRegistry: QuickAccessRegistry;
    protected readonly editorManager: EditorManager;
    registerQuickAccessProvider(): void;
    getPicks(filter: string, token: CancellationToken): (QuickPickItem | QuickPickSeparator)[];
    protected toItem(uri: URI): QuickPickItem;
    protected openFile(uri: URI): void;
}
//# sourceMappingURL=quick-editor-service.d.ts.map