/********************************************************************************
 * Copyright (C) 2017 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { OpenerService, KeybindingRegistry, QuickAccessRegistry, QuickAccessProvider } from '@theia/core/lib/browser';
import { WorkspaceService } from '@theia/workspace/lib/browser/workspace-service';
import URI from '@theia/core/lib/common/uri';
import { FileSearchService } from '../common/file-search-service';
import { CancellationToken, Command } from '@theia/core/lib/common';
import { LabelProvider } from '@theia/core/lib/browser/label-provider';
import { NavigationLocationService } from '@theia/editor/lib/browser/navigation/navigation-location-service';
import { MessageService } from '@theia/core/lib/common/message-service';
import { FileSystemPreferences } from '@theia/filesystem/lib/browser';
import { EditorOpenerOptions, Range } from '@theia/editor/lib/browser';
import { QuickInputService, QuickPickItem, QuickPicks } from '@theia/core/lib/browser/quick-input/quick-input-service';
export declare const quickFileOpen: Command;
export interface FilterAndRange {
    filter: string;
    range?: Range;
}
export declare type FileQuickPickItem = QuickPickItem & {
    uri: URI;
};
export declare class QuickFileOpenService implements QuickAccessProvider {
    static readonly PREFIX = "";
    protected readonly keybindingRegistry: KeybindingRegistry;
    protected readonly workspaceService: WorkspaceService;
    protected readonly openerService: OpenerService;
    protected readonly quickInputService: QuickInputService;
    protected readonly quickAccessRegistry: QuickAccessRegistry;
    protected readonly fileSearchService: FileSearchService;
    protected readonly labelProvider: LabelProvider;
    protected readonly navigationLocationService: NavigationLocationService;
    protected readonly messageService: MessageService;
    protected readonly fsPreferences: FileSystemPreferences;
    registerQuickAccessProvider(): void;
    /**
     * Whether to hide .gitignored (and other ignored) files.
     */
    protected hideIgnoredFiles: boolean;
    /**
     * Whether the dialog is currently open.
     */
    protected isOpen: boolean;
    private updateIsOpen;
    protected filterAndRangeDefault: {
        filter: string;
        range: undefined;
    };
    /**
     * Tracks the user file search filter and location range e.g. fileFilter:line:column or fileFilter:line,column
     */
    protected filterAndRange: FilterAndRange;
    /**
     * The score constants when comparing file search results.
     */
    private static readonly Scores;
    protected init(): void;
    isEnabled(): boolean;
    open(): void;
    protected hideQuickPick(): void;
    /**
     * Get a string (suitable to show to the user) representing the keyboard
     * shortcut used to open the quick file open menu.
     */
    protected getKeyCommand(): string | undefined;
    getPicks(filter: string, token: CancellationToken): Promise<QuickPicks>;
    protected compareItems(left: FileQuickPickItem, right: FileQuickPickItem): number;
    openFile(uri: URI): void;
    protected buildOpenerOptions(): EditorOpenerOptions;
    private toItem;
    private getItemIconClasses;
    private getItemDescription;
    private getPlaceHolder;
    /**
     * Splits the given expression into a structure of search-file-filter and
     * location-range.
     *
     * @param expression patterns of <path><#|:><line><#|:|,><col?>
     */
    protected splitFilterAndRange(expression: string): FilterAndRange;
}
//# sourceMappingURL=quick-file-open.d.ts.map