/********************************************************************************
 * Copyright (C) 2019 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import URI from '@theia/core/lib/common/uri';
import { Breadcrumb } from '@theia/core/lib/browser/breadcrumbs/breadcrumbs-constants';
export declare class FilepathBreadcrumb implements Breadcrumb {
    readonly uri: URI;
    readonly label: string;
    readonly longLabel: string;
    readonly iconClass: string;
    readonly containerClass: string;
    constructor(uri: URI, label: string, longLabel: string, iconClass: string, containerClass: string);
    get id(): string;
    get type(): symbol;
}
export declare namespace FilepathBreadcrumb {
    function is(breadcrumb: Breadcrumb): breadcrumb is FilepathBreadcrumb;
}
//# sourceMappingURL=filepath-breadcrumb.d.ts.map