/********************************************************************************
 * Copyright (C) 2019 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { Disposable, Emitter, Event } from '@theia/core';
import URI from '@theia/core/lib/common/uri';
import { Breadcrumb, BreadcrumbsContribution, LabelProvider } from '@theia/core/lib/browser';
import { FilepathBreadcrumb } from './filepath-breadcrumb';
import { BreadcrumbsFileTreeWidget } from './filepath-breadcrumbs-container';
import { DirNode } from '../file-tree';
import { FileService } from '../file-service';
import { FileStat } from '../../common/files';
export declare const FilepathBreadcrumbType: unique symbol;
export interface FilepathBreadcrumbClassNameFactory {
    (location: URI, index: number): string;
}
export declare class FilepathBreadcrumbsContribution implements BreadcrumbsContribution {
    protected readonly labelProvider: LabelProvider;
    protected readonly fileSystem: FileService;
    protected readonly breadcrumbsFileTreeWidget: BreadcrumbsFileTreeWidget;
    protected readonly onDidChangeBreadcrumbsEmitter: Emitter<URI>;
    get onDidChangeBreadcrumbs(): Event<URI>;
    readonly type: symbol;
    readonly priority: number;
    computeBreadcrumbs(uri: URI): Promise<Breadcrumb[]>;
    protected getContainerClassCreator(fileURI: URI): FilepathBreadcrumbClassNameFactory;
    protected getIconClassCreator(fileURI: URI): FilepathBreadcrumbClassNameFactory;
    protected filterBreadcrumbs(_: URI, breadcrumb: FilepathBreadcrumb): boolean;
    attachPopupContent(breadcrumb: Breadcrumb, parent: HTMLElement): Promise<Disposable | undefined>;
    protected createRootNode(folderToOpen: FileStat): Promise<DirNode | undefined>;
}
//# sourceMappingURL=filepath-breadcrumbs-contribution.d.ts.map