/********************************************************************************
 * Copyright (C) 2017 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import URI from '@theia/core/lib/common/uri';
import { CompositeTreeNode, TreeModelImpl, TreeNode } from '@theia/core/lib/browser';
import { FileStatNode } from './file-tree';
import { LocationService } from '../location';
import { LabelProvider } from '@theia/core/lib/browser/label-provider';
import { FileService } from '../file-service';
import { FileChangesEvent, FileChange, FileOperationEvent } from '../../common/files';
import { MessageService } from '@theia/core/lib/common/message-service';
import { EnvVariablesServer } from '@theia/core/lib/common/env-variables';
export declare class FileTreeModel extends TreeModelImpl implements LocationService {
    protected readonly labelProvider: LabelProvider;
    protected readonly fileService: FileService;
    protected readonly messageService: MessageService;
    protected readonly environments: EnvVariablesServer;
    protected init(): void;
    get location(): URI | undefined;
    set location(uri: URI | undefined);
    drives(): Promise<URI[]>;
    get selectedFileStatNodes(): Readonly<FileStatNode>[];
    getNodesByUri(uri: URI): IterableIterator<TreeNode>;
    /**
     * to workaround https://github.com/Axosoft/nsfw/issues/42
     */
    protected onDidMove(event: FileOperationEvent): void;
    protected onFilesChanged(changes: FileChangesEvent): void;
    protected isRootAffected(changes: FileChangesEvent): boolean;
    protected getAffectedUris(changes: FileChangesEvent): URI[];
    protected isFileContentChanged(change: FileChange): boolean;
    protected refreshAffectedNodes(uris: URI[]): boolean;
    protected getAffectedNodes(uris: URI[]): Map<string, CompositeTreeNode>;
    copy(source: URI, target: Readonly<FileStatNode>): Promise<URI>;
    /**
     * Move the given source file or directory to the given target directory.
     */
    move(source: TreeNode, target: TreeNode): Promise<URI | undefined>;
    protected shouldReplace(fileName: string): Promise<boolean>;
}
//# sourceMappingURL=file-tree-model.d.ts.map