/********************************************************************************
 * Copyright (C) 2019 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
/// <reference types="express" />
import express = require('@theia/core/shared/express');
import { BackendApplicationContribution } from '@theia/core/lib/node';
export declare class NodeFileUploadService implements BackendApplicationContribution {
    configure(app: express.Application): Promise<void>;
    /**
     * @returns URL path on which to accept file uploads.
     */
    protected getHttpFileUploadPath(): Promise<string>;
    /**
     * @returns Path to a folder where to temporarily store uploads.
     */
    protected getTemporaryUploadDest(): Promise<string>;
    protected handleFileUpload(request: express.Request, response: express.Response): Promise<void>;
}
//# sourceMappingURL=node-file-upload-service.d.ts.map