/********************************************************************************
 * Copyright (C) 2020 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { Endpoint, FrontendApplicationContribution } from '@theia/core/lib/browser';
import { EnvVariablesServer } from '@theia/core/lib/common/env-variables';
/**
 * Fetch values from the backend's environment and caches them locally.
 * Helps with deploying various mini-browser endpoints.
 */
export declare class MiniBrowserEnvironment implements FrontendApplicationContribution {
    protected _hostPatternPromise: Promise<string>;
    protected _hostPattern?: string;
    protected environment: EnvVariablesServer;
    protected postConstruct(): void;
    get hostPatternPromise(): Promise<string>;
    get hostPattern(): string | undefined;
    onStart(): Promise<void>;
    /**
     * Throws if `hostPatternPromise` is not yet resolved.
     */
    getEndpoint(uuid: string, hostname?: string): Endpoint;
    /**
     * Throws if `hostPatternPromise` is not yet resolved.
     */
    getRandomEndpoint(): Endpoint;
    protected getHostPattern(): Promise<string>;
    protected getDefaultHostname(): string;
}
//# sourceMappingURL=mini-browser-environment.d.ts.map