/********************************************************************************
 * Copyright (c) 2021 SAP SE or an SAP affiliate company and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
/// <reference types="@theia/monaco-editor-core/monaco" />
import { InputBox, InputOptions, KeybindingRegistry, PickOptions, QuickInputButton, QuickInputService, QuickPick, QuickPickItem, QuickPickItemHighlights, QuickPickOptions } from '@theia/core/lib/browser';
import { CancellationToken, Event } from '@theia/core/lib/common';
export declare class MonacoQuickInputImplementation implements monaco.quickInput.IQuickInputService {
    controller: monaco.quickInput.QuickInputController;
    quickAccess: monaco.quickInput.IQuickAccessController;
    protected readonly contextKeyService: monaco.contextKeyService.ContextKeyService;
    protected container: HTMLElement;
    private quickInputList;
    get backButton(): monaco.quickInput.IQuickInputButton;
    get onShow(): Event<void>;
    get onHide(): Event<void>;
    constructor();
    setContextKey(key: string | undefined): void;
    createQuickPick<T extends monaco.quickInput.IQuickPickItem>(): monaco.quickInput.IQuickPick<T>;
    createInputBox(): monaco.quickInput.IInputBox;
    open(filter: string): void;
    input(options?: monaco.quickInput.IInputOptions, token?: CancellationToken): Promise<string | undefined>;
    pick<T extends monaco.quickInput.IQuickPickItem, O extends monaco.quickInput.IPickOptions<T>>(picks: Promise<T[]> | T[], options?: O, token?: CancellationToken): Promise<(O extends {
        canPickMany: true;
    } ? T[] : T) | undefined>;
    hide(): void;
    focus(): void;
    toggle(): void;
    applyStyles(styles: monaco.quickInput.IQuickInputStyles): void;
    layout(dimension: monaco.editor.IDimension, titleBarOffset: number): void;
    navigate?(next: boolean, quickNavigate?: monaco.quickInput.IQuickNavigateConfiguration): void;
    dispose(): void;
    cancel(): Promise<void>;
    back(): Promise<void>;
    accept?(keyMods?: monaco.quickInput.IKeyMods): Promise<void>;
    private initContainer;
    private initController;
    private getOptions;
}
export declare class MonacoQuickInputService implements QuickInputService {
    private monacoService;
    protected readonly keybindingRegistry: KeybindingRegistry;
    get backButton(): QuickInputButton;
    get onShow(): Event<void>;
    get onHide(): Event<void>;
    open(filter: string): void;
    createInputBox(): InputBox;
    input(options?: InputOptions, token?: CancellationToken): Promise<string | undefined>;
    pick<T extends QuickPickItem, O extends PickOptions<T>>(picks: T[] | Promise<T[]>, options?: O, token?: CancellationToken): Promise<(O extends {
        canPickMany: true;
    } ? T[] : T) | undefined>;
    showQuickPick<T extends QuickPickItem>(items: T[], options?: QuickPickOptions<T>): Promise<T>;
    createQuickPick<T extends QuickPickItem>(): QuickPick<T>;
    wrapQuickPick<T extends QuickPickItem>(wrapped: monaco.quickInput.IQuickPick<MonacoQuickPickItem<T>>): QuickPick<T>;
    protected convertItems<T extends QuickPickItem>(item: T): MonacoQuickPickItem<T>;
    hide(): void;
}
export declare class MonacoQuickPickItem<T extends QuickPickItem> implements monaco.quickInput.IQuickPickItem {
    readonly item: T;
    readonly type?: 'item' | 'separator';
    readonly id?: string;
    readonly label: string;
    readonly meta?: string;
    readonly ariaLabel?: string;
    readonly description?: string;
    readonly detail?: string;
    readonly keybinding?: monaco.keybindings.ResolvedKeybinding;
    readonly iconClasses?: string[];
    buttons?: monaco.quickInput.IQuickInputButton[];
    readonly alwaysShow?: boolean;
    readonly highlights?: QuickPickItemHighlights;
    constructor(item: T, kbRegistry: KeybindingRegistry);
    accept(): void;
}
//# sourceMappingURL=monaco-quick-input-service.d.ts.map