/********************************************************************************
 * Copyright (C) 2018 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
/// <reference types="@theia/monaco-editor-core/monaco" />
import { URI as Uri } from '@theia/core/shared/vscode-uri';
import { Emitter } from '@theia/core/lib/common/event';
import { FileSystemPreferences } from '@theia/filesystem/lib/browser';
import { EditorManager } from '@theia/editor/lib/browser';
import { MonacoTextModelService } from './monaco-text-model-service';
import { WillSaveMonacoModelEvent, MonacoEditorModel, MonacoModelContentChangedEvent } from './monaco-editor-model';
import { ProblemManager } from '@theia/markers/lib/browser';
import { MaybePromise } from '@theia/core/lib/common/types';
import { FileService } from '@theia/filesystem/lib/browser/file-service';
export declare namespace WorkspaceFileEdit {
    function is(arg: Edit): arg is monaco.languages.WorkspaceFileEdit;
}
export declare namespace WorkspaceTextEdit {
    function is(arg: Edit): arg is monaco.languages.WorkspaceTextEdit;
}
export declare type Edit = monaco.languages.WorkspaceFileEdit | monaco.languages.WorkspaceTextEdit;
export declare namespace ResourceFileEdit {
    function is(arg: monaco.editor.ResourceEdit): arg is monaco.editor.ResourceFileEdit;
}
export declare namespace ResourceTextEdit {
    function is(arg: monaco.editor.ResourceEdit): arg is monaco.editor.ResourceTextEdit;
}
export interface WorkspaceFoldersChangeEvent {
    readonly added: WorkspaceFolder[];
    readonly removed: WorkspaceFolder[];
}
export interface WorkspaceFolder {
    readonly uri: Uri;
    readonly name: string;
    readonly index: number;
}
export declare class MonacoWorkspace {
    protected resolveReady: () => void;
    readonly ready: Promise<void>;
    protected readonly onDidOpenTextDocumentEmitter: Emitter<MonacoEditorModel>;
    readonly onDidOpenTextDocument: import("@theia/core/lib/common/event").Event<MonacoEditorModel>;
    protected readonly onDidCloseTextDocumentEmitter: Emitter<MonacoEditorModel>;
    readonly onDidCloseTextDocument: import("@theia/core/lib/common/event").Event<MonacoEditorModel>;
    protected readonly onDidChangeTextDocumentEmitter: Emitter<MonacoModelContentChangedEvent>;
    readonly onDidChangeTextDocument: import("@theia/core/lib/common/event").Event<MonacoModelContentChangedEvent>;
    protected readonly onWillSaveTextDocumentEmitter: Emitter<WillSaveMonacoModelEvent>;
    readonly onWillSaveTextDocument: import("@theia/core/lib/common/event").Event<WillSaveMonacoModelEvent>;
    protected readonly onDidSaveTextDocumentEmitter: Emitter<MonacoEditorModel>;
    readonly onDidSaveTextDocument: import("@theia/core/lib/common/event").Event<MonacoEditorModel>;
    protected readonly fileService: FileService;
    protected readonly filePreferences: FileSystemPreferences;
    protected readonly textModelService: MonacoTextModelService;
    protected readonly editorManager: EditorManager;
    protected readonly problems: ProblemManager;
    protected init(): void;
    get textDocuments(): MonacoEditorModel[];
    getTextDocument(uri: string): MonacoEditorModel | undefined;
    protected fireDidOpen(model: MonacoEditorModel): void;
    protected doFireDidOpen(model: MonacoEditorModel): void;
    protected fireDidClose(model: MonacoEditorModel): void;
    protected fireDidChangeContent(event: MonacoModelContentChangedEvent): void;
    protected fireWillSave(event: WillSaveMonacoModelEvent): void;
    protected fireDidSave(model: MonacoEditorModel): void;
    protected readonly suppressedOpenIfDirty: MonacoEditorModel[];
    protected openEditorIfDirty(model: MonacoEditorModel): void;
    protected suppressOpenIfDirty(model: MonacoEditorModel, cb: () => MaybePromise<void>): Promise<void>;
    /**
     * Applies given edits to the given model.
     * The model is saved if no editors is opened for it.
     */
    applyBackgroundEdit(model: MonacoEditorModel, editOperations: monaco.editor.IIdentifiedSingleEditOperation[]): Promise<void>;
    applyBulkEdit(edits: monaco.editor.ResourceEdit[]): Promise<monaco.editor.IBulkEditResult & {
        success: boolean;
    }>;
    protected getAriaSummary(totalEdits: number, totalFiles: number): string;
    protected performTextEdits(edits: monaco.editor.ResourceTextEdit[]): Promise<{
        totalEdits: number;
        totalFiles: number;
    }>;
    protected performFileEdits(edits: monaco.editor.ResourceFileEdit[]): Promise<void>;
}
//# sourceMappingURL=monaco-workspace.d.ts.map