/********************************************************************************
 * Copyright (C) 2017 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
/// <reference types="react" />
import { Message } from '@theia/core/shared/@phosphor/messaging';
import { CommandService, SelectionService } from '@theia/core/lib/common';
import { CorePreferences, TreeModel, TreeDecoration, NodeProps, OpenerService, ContextMenuRenderer, TreeProps, TreeNode } from '@theia/core/lib/browser';
import { FileTreeWidget } from '@theia/filesystem/lib/browser';
import { WorkspaceService } from '@theia/workspace/lib/browser';
import { ApplicationShell } from '@theia/core/lib/browser/shell/application-shell';
import { FileNavigatorModel } from './navigator-model';
import * as React from '@theia/core/shared/react';
import { NavigatorContextKeyService } from './navigator-context-key-service';
export declare const FILE_NAVIGATOR_ID = "files";
export declare const LABEL = "No folder opened";
export declare const CLASS = "theia-Files";
export declare class FileNavigatorWidget extends FileTreeWidget {
    readonly props: TreeProps;
    readonly model: FileNavigatorModel;
    protected readonly commandService: CommandService;
    protected readonly selectionService: SelectionService;
    protected readonly workspaceService: WorkspaceService;
    protected readonly shell: ApplicationShell;
    protected readonly corePreferences: CorePreferences;
    protected readonly contextKeyService: NavigatorContextKeyService;
    protected readonly openerService: OpenerService;
    constructor(props: TreeProps, model: FileNavigatorModel, contextMenuRenderer: ContextMenuRenderer, commandService: CommandService, selectionService: SelectionService, workspaceService: WorkspaceService, shell: ApplicationShell);
    protected init(): void;
    protected doUpdateRows(): void;
    protected enableDndOnMainPanel(): void;
    protected getContainerTreeNode(): TreeNode | undefined;
    protected renderTree(model: TreeModel): React.ReactNode;
    protected renderTailDecorations(node: TreeNode, props: NodeProps): React.ReactNode;
    protected renderTailDecorationsForDirectoryNode(node: TreeNode, props: NodeProps, tailDecorations: (TreeDecoration.TailDecoration | TreeDecoration.TailDecorationIcon | TreeDecoration.TailDecorationIconClass)[]): React.ReactNode;
    protected shouldShowWelcomeView(): boolean;
    protected onAfterAttach(msg: Message): void;
    protected handleCopy(event: ClipboardEvent): void;
    protected handlePaste(event: ClipboardEvent): void;
    protected canOpenWorkspaceFileAndFolder: boolean;
    protected readonly openWorkspace: () => void;
    protected doOpenWorkspace(): void;
    protected readonly openFolder: () => void;
    protected doOpenFolder(): void;
    protected readonly addFolder: () => void;
    protected doAddFolder(): void;
    protected readonly keyUpHandler: (e: React.KeyboardEvent) => void;
    /**
     * When a multi-root workspace is opened, a user can remove all the folders from it.
     * Instead of displaying an empty navigator tree, this will show a button to add more folders.
     */
    protected renderEmptyMultiRootWorkspace(): React.ReactNode;
    protected isEmptyMultiRootWorkspace(model: TreeModel): boolean;
    protected handleClickEvent(node: TreeNode | undefined, event: React.MouseEvent<HTMLElement>): void;
    protected onAfterShow(msg: Message): void;
    protected onAfterHide(msg: Message): void;
    protected updateSelectionContextKeys(): void;
}
//# sourceMappingURL=navigator-widget.d.ts.map