/********************************************************************************
 * Copyright (C) 2021 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
/// <reference types="lodash" />
import { FileStatNode, FileTreeModel } from '@theia/filesystem/lib/browser';
import { ApplicationShell, CompositeTreeNode, NavigatableWidget, OpenerService, TreeNode, Widget, TabBar } from '@theia/core/lib/browser';
import { WorkspaceService } from '@theia/workspace/lib/browser';
import { DisposableCollection } from '@theia/core/lib/common';
export interface OpenEditorNode extends FileStatNode {
    widget: Widget;
}
export declare namespace OpenEditorNode {
    function is(node: object | undefined): node is OpenEditorNode;
}
export declare class OpenEditorsModel extends FileTreeModel {
    static GROUP_NODE_ID_PREFIX: string;
    static AREA_NODE_ID_PREFIX: string;
    protected readonly applicationShell: ApplicationShell;
    protected readonly workspaceService: WorkspaceService;
    protected readonly openerService: OpenerService;
    protected toDisposeOnPreviewWidgetReplaced: DisposableCollection;
    protected _editorWidgetsByGroup: Map<number, {
        widgets: NavigatableWidget[];
        tabbar: TabBar<Widget>;
    }>;
    protected _editorWidgetsByArea: Map<ApplicationShell.Area, NavigatableWidget[]>;
    protected _lastEditorWidgetsByArea: Map<ApplicationShell.Area, NavigatableWidget[]>;
    get editorWidgets(): NavigatableWidget[];
    getTabBarForGroup(id: number): TabBar<Widget> | undefined;
    protected init(): void;
    protected setupHandlers(): void;
    protected initializeRoot(): Promise<void>;
    protected updateOpenWidgets: import("lodash").DebouncedFunc<(layoutModifiedArea?: "main" | "top" | "left" | "right" | "bottom" | undefined) => Promise<void>>;
    protected doUpdateOpenWidgets(layoutModifiedArea?: ApplicationShell.Area): Promise<void>;
    protected shouldRebuildTreeOnLayoutModified(area: ApplicationShell.Area): boolean;
    protected tryCreateWidgetGroupMap(): Map<Widget, CompositeTreeNode>;
    protected buildRootFromOpenedWidgets(widgetsByArea: Map<ApplicationShell.Area, NavigatableWidget[]>): Promise<CompositeTreeNode>;
    protected doOpenNode(node: TreeNode): void;
}
//# sourceMappingURL=navigator-open-editors-tree-model.d.ts.map