/********************************************************************************
 * Copyright (C) 2021 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
/// <reference types="react" />
import * as React from '@theia/core/shared/react';
import { interfaces, Container } from '@theia/core/shared/inversify';
import { ApplicationShell, ContextMenuRenderer, NavigatableWidget, NodeProps, TabBar, TreeProps, TreeWidget, Widget } from '@theia/core/lib/browser';
import { OpenEditorNode, OpenEditorsModel } from './navigator-open-editors-tree-model';
import { FileTreeWidget } from '@theia/filesystem/lib/browser';
import { CommandService } from '@theia/core/lib/common';
export declare const OPEN_EDITORS_PROPS: TreeProps;
export interface OpenEditorsNodeRow extends TreeWidget.NodeRow {
    node: OpenEditorNode;
}
export declare class OpenEditorsWidget extends FileTreeWidget {
    readonly props: TreeProps;
    readonly model: OpenEditorsModel;
    protected readonly contextMenuRenderer: ContextMenuRenderer;
    static ID: string;
    static LABEL: string;
    protected readonly applicationShell: ApplicationShell;
    protected readonly commandService: CommandService;
    static createContainer(parent: interfaces.Container): Container;
    static createWidget(parent: interfaces.Container): OpenEditorsWidget;
    constructor(props: TreeProps, model: OpenEditorsModel, contextMenuRenderer: ContextMenuRenderer);
    init(): void;
    get editorWidgets(): NavigatableWidget[];
    protected activeTreeNodePrefixElement: string | undefined | null;
    protected renderNode(node: OpenEditorNode, props: NodeProps): React.ReactNode;
    protected isGroupNode(node: OpenEditorNode): boolean;
    protected isAreaNode(node: OpenEditorNode): boolean;
    protected doRenderNodeRow({ node, depth }: OpenEditorsNodeRow): React.ReactNode;
    protected renderInteractables(node: OpenEditorNode, props: NodeProps): React.ReactNode;
    protected handleGroupActionIconClicked: (e: React.MouseEvent<HTMLAnchorElement>) => Promise<void>;
    protected doHandleGroupActionIconClicked(e: React.MouseEvent<HTMLAnchorElement>): Promise<void>;
    protected sanitizeInputFromClickHandler(groupFromTarget?: string): ApplicationShell.Area | TabBar<Widget> | undefined;
    protected renderPrefixIcon(node: OpenEditorNode): React.ReactNode;
    protected getPrefixIconClass(node: OpenEditorNode): string;
    protected closeEditor: (e: React.MouseEvent<HTMLDivElement>) => Promise<void>;
    protected doCloseEditor(e: React.MouseEvent<HTMLDivElement>): Promise<void>;
    protected handleClickEvent(node: OpenEditorNode | undefined, event: React.MouseEvent<HTMLElement>): void;
    protected handleContextMenuEvent(node: OpenEditorNode | undefined, event: React.MouseEvent<HTMLElement>): void;
}
//# sourceMappingURL=navigator-open-editors-widget.d.ts.map