/********************************************************************************
 * Copyright (C) 2020 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
/// <reference types="@theia/monaco-editor-core/monaco" />
import { MonacoEditorModel } from '@theia/monaco/lib/browser/monaco-editor-model';
import { MonacoEditorFactory } from '@theia/monaco/lib/browser/monaco-editor-provider';
import { MonacoContextMenuService } from '@theia/monaco/lib/browser/monaco-context-menu';
import { MonacoEditor, MonacoEditorServices } from '@theia/monaco/lib/browser/monaco-editor';
export declare class OutputEditorFactory implements MonacoEditorFactory {
    protected readonly services: MonacoEditorServices;
    protected readonly contextMenuService: MonacoContextMenuService;
    readonly scheme: string;
    create(model: MonacoEditorModel, defaultsOptions: MonacoEditor.IOptions, defaultOverrides: monaco.editor.IEditorOverrideServices): MonacoEditor;
    protected createOptions(model: MonacoEditorModel, defaultOptions: MonacoEditor.IOptions): MonacoEditor.IOptions;
    protected createOverrides(model: MonacoEditorModel, defaultOverrides: monaco.editor.IEditorOverrideServices): monaco.editor.IEditorOverrideServices;
}
//# sourceMappingURL=output-editor-factory.d.ts.map