"use strict";
/********************************************************************************
 * Copyright (C) 2018 Red Hat, Inc. and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.PluginMessageWriter = exports.AbstractMessageWriter = void 0;
const vscode_ws_jsonrpc_1 = require("@theia/core/shared/vscode-ws-jsonrpc");
class AbstractMessageWriter {
    constructor() {
        this.errorEmitter = new vscode_ws_jsonrpc_1.Emitter();
        this.closeEmitter = new vscode_ws_jsonrpc_1.Emitter();
    }
    dispose() {
        this.errorEmitter.dispose();
        this.closeEmitter.dispose();
    }
    get onError() {
        return this.errorEmitter.event;
    }
    fireError(error, message, count) {
        this.errorEmitter.fire([this.asError(error), message, count]);
    }
    get onClose() {
        return this.closeEmitter.event;
    }
    fireClose() {
        this.closeEmitter.fire(undefined);
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    asError(error) {
        if (error instanceof Error) {
            return error;
        }
        else {
            return new Error(`Writer received error. Reason: ${typeof error.message === 'string' ? error.message : 'unknown'}`);
        }
    }
}
exports.AbstractMessageWriter = AbstractMessageWriter;
/**
 * Support for writing string message through RPC protocol.
 */
class PluginMessageWriter extends AbstractMessageWriter {
    constructor(id, proxy) {
        super();
        this.id = id;
        this.proxy = proxy;
    }
    write(arg) {
        const content = JSON.stringify(arg);
        this.proxy.$sendMessage(this.id, content);
    }
}
exports.PluginMessageWriter = PluginMessageWriter;
//# sourceMappingURL=plugin-message-writer.js.map