/********************************************************************************
 * Copyright (C) 2020 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { BinaryBuffer } from '@theia/core/lib/common/buffer';
export interface IFullSemanticTokensDto {
    id: number;
    type: 'full';
    data: Uint32Array;
}
export interface IDeltaSemanticTokensDto {
    id: number;
    type: 'delta';
    deltas: {
        start: number;
        deleteCount: number;
        data?: Uint32Array;
    }[];
}
export declare type ISemanticTokensDto = IFullSemanticTokensDto | IDeltaSemanticTokensDto;
export declare function encodeSemanticTokensDto(semanticTokens: ISemanticTokensDto): BinaryBuffer;
export declare function decodeSemanticTokensDto(_buff: BinaryBuffer): ISemanticTokensDto;
//# sourceMappingURL=semantic-tokens-dto.d.ts.map