/********************************************************************************
 * Copyright (C) 2020 Red Hat, Inc. and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { ContextKeyService, ContextKey } from '@theia/core/lib/browser/context-key-service';
import { Emitter } from '@theia/core/lib/common';
export declare class CommentsContextKeyService {
    protected readonly contextKeyService: ContextKeyService;
    protected readonly contextKeys: Set<string>;
    protected readonly onDidChangeEmitter: Emitter<void>;
    readonly onDidChange: import("@theia/core").Event<void>;
    protected _commentIsEmpty: ContextKey<boolean>;
    protected _commentController: ContextKey<string | undefined>;
    protected _comment: ContextKey<string | undefined>;
    get commentController(): ContextKey<string | undefined>;
    get comment(): ContextKey<string | undefined>;
    get commentIsEmpty(): ContextKey<boolean>;
    protected init(): void;
    setExpression(expression: string): void;
    match(expression: string | undefined): boolean;
}
//# sourceMappingURL=comments-context-key-service.d.ts.map