/********************************************************************************
 * Copyright (C) 2020 Red Hat, Inc. and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
/// <reference types="@theia/monaco-editor-core/monaco" />
/// <reference types="@theia/monaco/src/typings/monaco/index" />
import { CommentingRangeDecorator } from './comments-decorator';
import { EditorManager, EditorMouseEvent } from '@theia/editor/lib/browser';
import { CommentsService } from './comments-service';
import { CommandRegistry, MenuModelRegistry } from '@theia/core/lib/common';
import { CommentsContextKeyService } from './comments-context-key-service';
import { ContextKeyService } from '@theia/core/lib/browser/context-key-service';
export declare class CommentsContribution {
    protected readonly rangeDecorator: CommentingRangeDecorator;
    protected readonly commentService: CommentsService;
    protected readonly editorManager: EditorManager;
    private addInProgress;
    private commentWidgets;
    private commentInfos;
    private emptyThreadsToAddQueue;
    protected readonly menus: MenuModelRegistry;
    protected readonly commentsContextKeyService: CommentsContextKeyService;
    protected readonly contextKeyService: ContextKeyService;
    protected readonly commands: CommandRegistry;
    constructor(rangeDecorator: CommentingRangeDecorator, commentService: CommentsService, editorManager: EditorManager);
    private onEditorMouseDown;
    private beginCompute;
    private setComments;
    get editor(): monaco.editor.IStandaloneCodeEditor | undefined;
    private displayCommentThread;
    addOrToggleCommentAtLine(lineNumber: number, e: EditorMouseEvent | undefined): Promise<void>;
    private processNextThreadToAdd;
    private getCurrentEditor;
    addCommentAtLine(lineNumber: number, e: EditorMouseEvent | undefined): Promise<void>;
    addCommentAtLine2(lineNumber: number, ownerId: string): void;
}
//# sourceMappingURL=comments-contribution.d.ts.map