/********************************************************************************
 * Copyright (C) 2020 Red Hat, Inc. and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
/// <reference types="@theia/monaco-editor-core/monaco" />
/// <reference types="@theia/monaco/src/typings/monaco/index" />
import { CommentInfoMain } from './comments-service';
import { CommentingRanges } from '../../../common/plugin-api-rpc-model';
export declare class CommentingRangeDecorator {
    private decorationOptions;
    private commentingRangeDecorations;
    constructor();
    update(editor: monaco.editor.ICodeEditor, commentInfos: CommentInfoMain[]): void;
    getMatchedCommentAction(line: number): {
        ownerId: string;
        extensionId: string | undefined;
        label: string | undefined;
        commentingRangesInfo: CommentingRanges;
    }[];
}
//# sourceMappingURL=comments-decorator.d.ts.map