/********************************************************************************
 * Copyright (C) 2020 Red Hat, Inc. and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { Range, Comment, CommentInput, CommentOptions, CommentThread, CommentThreadChangedEvent } from '../../../common/plugin-api-rpc-model';
import { Event } from '@theia/core/lib/common/event';
import { CommentThreadCollapsibleState } from '../../../plugin/types-impl';
import { CommentProviderFeatures, CommentsExt, CommentsMain, CommentThreadChanges } from '../../../common/plugin-api-rpc';
import { Disposable } from '@theia/core/lib/common/disposable';
import { CommentsService, CommentInfoMain } from './comments-service';
import { UriComponents } from '../../../common/uri-components';
import { URI } from '@theia/core/shared/vscode-uri';
import { CancellationToken } from '@theia/core/lib/common';
import { RPCProtocol } from '../../../common/rpc-protocol';
import { interfaces } from '@theia/core/shared/inversify';
export declare class CommentThreadImpl implements CommentThread, Disposable {
    commentThreadHandle: number;
    controllerHandle: number;
    extensionId: string;
    threadId: string;
    resource: string;
    private _range;
    private _input?;
    get input(): CommentInput | undefined;
    set input(value: CommentInput | undefined);
    private readonly onDidChangeInputEmitter;
    get onDidChangeInput(): Event<CommentInput | undefined>;
    private _label;
    get label(): string | undefined;
    set label(label: string | undefined);
    private readonly onDidChangeLabelEmitter;
    readonly onDidChangeLabel: Event<string | undefined>;
    private _contextValue;
    get contextValue(): string | undefined;
    set contextValue(context: string | undefined);
    private _comments;
    get comments(): Comment[] | undefined;
    set comments(newComments: Comment[] | undefined);
    private readonly onDidChangeCommentsEmitter;
    get onDidChangeComments(): Event<Comment[] | undefined>;
    set range(range: Range);
    get range(): Range;
    private readonly onDidChangeRangeEmitter;
    onDidChangeRange: Event<Range>;
    private _collapsibleState;
    get collapsibleState(): CommentThreadCollapsibleState | undefined;
    set collapsibleState(newState: CommentThreadCollapsibleState | undefined);
    private readonly onDidChangeCollapsibleStateEmitter;
    readonly onDidChangeCollapsibleState: Event<CommentThreadCollapsibleState | undefined>;
    private _isDisposed;
    get isDisposed(): boolean;
    constructor(commentThreadHandle: number, controllerHandle: number, extensionId: string, threadId: string, resource: string, _range: Range);
    batchUpdate(changes: CommentThreadChanges): void;
    dispose(): void;
}
export declare class CommentController {
    private readonly _proxy;
    private readonly _commentService;
    private readonly _handle;
    private readonly _uniqueId;
    private readonly _id;
    private readonly _label;
    private _features;
    get handle(): number;
    get id(): string;
    get contextValue(): string;
    get proxy(): CommentsExt;
    get label(): string;
    get options(): CommentOptions | undefined;
    private readonly threads;
    activeCommentThread?: CommentThread;
    get features(): CommentProviderFeatures;
    constructor(_proxy: CommentsExt, _commentService: CommentsService, _handle: number, _uniqueId: string, _id: string, _label: string, _features: CommentProviderFeatures);
    updateFeatures(features: CommentProviderFeatures): void;
    createCommentThread(extensionId: string, commentThreadHandle: number, threadId: string, resource: UriComponents, range: Range): CommentThread;
    updateCommentThread(commentThreadHandle: number, threadId: string, resource: UriComponents, changes: CommentThreadChanges): void;
    deleteCommentThread(commentThreadHandle: number): void;
    deleteCommentThreadMain(commentThreadId: string): void;
    updateInput(input: string): void;
    private getKnownThread;
    getDocumentComments(resource: URI, token: CancellationToken): Promise<CommentInfoMain>;
    getCommentingRanges(resource: URI, token: CancellationToken): Promise<Range[]>;
    getAllComments(): CommentThread[];
    createCommentThreadTemplate(resource: UriComponents, range: Range): void;
    updateCommentThreadTemplate(threadHandle: number, range: Range): Promise<void>;
}
export declare class CommentsMainImp implements CommentsMain {
    private readonly proxy;
    private documentProviders;
    private workspaceProviders;
    private handlers;
    private commentControllers;
    private activeCommentThread?;
    private readonly commentService;
    constructor(rpc: RPCProtocol, container: interfaces.Container);
    $registerCommentController(handle: number, id: string, label: string): void;
    $unregisterCommentController(handle: number): void;
    $updateCommentControllerFeatures(handle: number, features: CommentProviderFeatures): void;
    $createCommentThread(handle: number, commentThreadHandle: number, threadId: string, resource: UriComponents, range: Range, extensionId: string): CommentThread | undefined;
    $updateCommentThread(handle: number, commentThreadHandle: number, threadId: string, resource: UriComponents, changes: CommentThreadChanges): void;
    $deleteCommentThread(handle: number, commentThreadHandle: number): void;
    private getHandler;
    $onDidCommentThreadsChange(handle: number, event: CommentThreadChangedEvent): void;
    dispose(): void;
}
//# sourceMappingURL=comments-main.d.ts.map