/********************************************************************************
 * Copyright (c) 2021 SAP SE or an SAP affiliate company and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import URI from '@theia/core/lib/common/uri';
import { ApplicationShell, OpenerOptions, OpenHandler, Widget, WidgetManager } from '@theia/core/lib/browser';
import { CustomEditor, CustomEditorSelector } from '../../../common';
import { CustomEditorWidget } from './custom-editor-widget';
export declare class CustomEditorOpener implements OpenHandler {
    private readonly editor;
    protected readonly shell: ApplicationShell;
    protected readonly widgetManager: WidgetManager;
    readonly id: string;
    readonly label: string;
    private readonly onDidOpenCustomEditorEmitter;
    readonly onDidOpenCustomEditor: import("@theia/core").Event<CustomEditorWidget>;
    constructor(editor: CustomEditor, shell: ApplicationShell, widgetManager: WidgetManager);
    static toCustomEditorId(editorViewType: string): string;
    canHandle(uri: URI): number;
    getPriority(): number;
    protected readonly pendingWidgetPromises: Map<string, Promise<CustomEditorWidget>>;
    open(uri: URI, options?: OpenerOptions): Promise<Widget | undefined>;
    matches(selectors: CustomEditorSelector[], resource: URI): boolean;
    selectorMatches(selector: CustomEditorSelector, resource: URI): boolean;
}
//# sourceMappingURL=custom-editor-opener.d.ts.map