/********************************************************************************
 * Copyright (c) 2021 SAP SE or an SAP affiliate company and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import URI from '@theia/core/lib/common/uri';
import { Reference } from '@theia/core/lib/common/reference';
import { CustomEditorModel } from './custom-editors-main';
export declare class CustomEditorService {
    protected _models: CustomEditorModelManager;
    get models(): CustomEditorModelManager;
}
export declare class CustomEditorModelManager {
    private readonly references;
    add(resource: URI, viewType: string, model: Promise<CustomEditorModel>): Promise<Reference<CustomEditorModel>>;
    get(resource: URI, viewType: string): Promise<CustomEditorModel | undefined>;
    tryRetain(resource: URI, viewType: string): Promise<Reference<CustomEditorModel>> | undefined;
    disposeAllModelsForView(viewType: string): void;
    private key;
}
export declare function once<T extends Function>(this: unknown, fn: T): T;
//# sourceMappingURL=custom-editor-service.d.ts.map