/********************************************************************************
 * Copyright (c) 2021 SAP SE or an SAP affiliate company and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import URI from '@theia/core/lib/common/uri';
import { NavigatableWidget, Saveable, SaveableSource, SaveOptions } from '@theia/core/lib/browser';
import { Reference } from '@theia/core/lib/common/reference';
import { WebviewWidget } from '../webview/webview';
import { UndoRedoService } from './undo-redo-service';
import { CustomEditorModel } from './custom-editors-main';
export declare class CustomEditorWidget extends WebviewWidget implements SaveableSource, NavigatableWidget {
    static FACTORY_ID: string;
    id: string;
    resource: URI;
    protected _modelRef: Reference<CustomEditorModel>;
    get modelRef(): Reference<CustomEditorModel>;
    set modelRef(modelRef: Reference<CustomEditorModel>);
    get saveable(): Saveable;
    protected readonly undoRedoService: UndoRedoService;
    protected init(): void;
    undo(): void;
    redo(): void;
    save(options?: SaveOptions): Promise<void>;
    saveAs(source: URI, target: URI, options?: SaveOptions): Promise<void>;
    getResourceUri(): URI | undefined;
    createMoveToUri(resourceUri: URI): URI | undefined;
    storeState(): CustomEditorWidget.State;
    restoreState(oldState: CustomEditorWidget.State): void;
    onMove(handler: (newResource: URI) => Promise<void>): void;
    private _moveHandler?;
    private doMove;
}
export declare namespace CustomEditorWidget {
    interface State extends WebviewWidget.State {
        strResource: string;
    }
}
//# sourceMappingURL=custom-editor-widget.d.ts.map