/********************************************************************************
 * Copyright (C) 2019 Red Hat, Inc. and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { DecorationsMain } from '../../../common/plugin-api-rpc';
import { interfaces } from '@theia/core/shared/inversify';
import { Disposable } from '@theia/core/lib/common/disposable';
import { RPCProtocol } from '../../../common/rpc-protocol';
import { UriComponents } from '../../../common/uri-components';
export declare class DecorationsMainImpl implements DecorationsMain, Disposable {
    private readonly proxy;
    private readonly providers;
    private readonly decorationsService;
    constructor(rpc: RPCProtocol, container: interfaces.Container);
    dispose(): void;
    $registerDecorationProvider(handle: number): Promise<void>;
    $onDidChange(handle: number, resources: UriComponents[]): void;
    $unregisterDecorationProvider(handle: number): void;
}
//# sourceMappingURL=decorations-main.d.ts.map