/********************************************************************************
 * Copyright (C) 2018 Red Hat, Inc. and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { URI as CodeUri } from '@theia/core/shared/vscode-uri';
import { MenuPath, ILogger, CommandRegistry, Command, SelectionService, CommandHandler, Disposable } from '@theia/core';
import { EditorWidget } from '@theia/editor/lib/browser';
import { MenuModelRegistry } from '@theia/core/lib/common';
import { TabBarToolbarRegistry } from '@theia/core/lib/browser/shell/tab-bar-toolbar';
import { DeployedPlugin, Menu, ScmCommandArg, TimelineCommandArg } from '../../../common';
import { ScmService } from '@theia/scm/lib/browser/scm-service';
import { ResourceContextKey } from '@theia/core/lib/browser/resource-context-key';
import { ViewContextKeyService } from '../view/view-context-key-service';
import { WebviewWidget } from '../webview/webview';
import { ContextKeyService } from '@theia/core/lib/browser/context-key-service';
import { TimelineItem } from '@theia/timeline/lib/common/timeline-model';
import { QuickCommandService } from '@theia/core/lib/browser';
declare type CodeEditorWidget = EditorWidget | WebviewWidget;
export declare class CodeEditorWidgetUtil {
    is(arg: any): arg is CodeEditorWidget;
    getResourceUri(editor: CodeEditorWidget): CodeUri | undefined;
}
export declare class MenusContributionPointHandler {
    protected readonly menuRegistry: MenuModelRegistry;
    protected readonly commands: CommandRegistry;
    protected readonly logger: ILogger;
    protected readonly scmService: ScmService;
    protected readonly quickCommandService: QuickCommandService;
    protected readonly tabBarToolbar: TabBarToolbarRegistry;
    protected readonly selectionService: SelectionService;
    protected readonly resourceContextKey: ResourceContextKey;
    protected readonly viewContextKeys: ViewContextKeyService;
    protected readonly contextKeyService: ContextKeyService;
    protected readonly codeEditorWidgetUtil: CodeEditorWidgetUtil;
    handle(plugin: DeployedPlugin): Disposable;
    /**
     * Transforms the structure of Menus & Submenus
     * into something more tree-like.
     */
    protected getMenusTree(plugin: DeployedPlugin): MenuTree[];
    protected registerAction(plugin: DeployedPlugin, location: string, action: MenuTree): Disposable;
    protected static parseMenuPaths(value: string): MenuPath[];
    protected registerCommandPaletteAction(menu: Menu): Disposable;
    protected registerEditorTitleAction(location: string, action: Menu): Disposable;
    protected registerViewTitleAction(location: string, action: Menu): Disposable;
    protected registerViewItemContextAction(menu: MenuTree): Disposable;
    protected registerScmResourceGroupAction(menu: MenuTree): Disposable;
    protected registerScmResourceFolderAction(menu: MenuTree): Disposable;
    protected registerScmResourceStateAction(menu: MenuTree): Disposable;
    protected registerTimelineItemAction(menu: MenuTree): Disposable;
    protected registerCommentThreadAction(menu: MenuTree, plugin: DeployedPlugin): Disposable;
    protected registerCommentTitleAction(menu: MenuTree): Disposable;
    protected registerCommentContextAction(menu: MenuTree): Disposable;
    protected registerDebugCallstackAction(menu: MenuTree): Disposable;
    protected registerTreeMenuAction(menuPath: MenuPath, menu: MenuTree): Disposable;
    protected toTreeArgs(...args: any[]): any[];
    protected registerTitleAction(location: string, action: Menu, handler: CommandHandler): Disposable;
    protected registerScmTitleAction(location: string, action: Menu): Disposable;
    protected registerScmMenuAction(menuPath: MenuPath, menu: MenuTree): Disposable;
    protected toScmArgs(...args: any[]): any[];
    protected toScmArg(arg: any): ScmCommandArg | undefined;
    protected toTimelineArgs(...args: any[]): any[];
    protected toTimelineArg(arg: TimelineItem): TimelineCommandArg;
    protected toCommentArgs(...args: any[]): any[];
    protected registerGlobalMenuAction(menu: MenuTree, location: string, plugin: DeployedPlugin): Disposable;
    protected registerMenuAction(menuPath: MenuPath, menu: MenuTree, handler: (command: string) => CommandHandler): Disposable;
    protected createSyntheticCommandId(command: string, { prefix }: {
        prefix: string;
    }): string;
    protected onDidRegisterCommand(id: string, cb: (command: Command) => void): Disposable;
}
/**
 * MenuTree representing a (sub)menu in the menu tree structure.
 */
export declare class MenuTree implements Menu {
    /** The location where the menu item will be open from. */
    readonly id?: string | undefined;
    /** The label of the menu item which leads to the submenu. */
    label?: string | undefined;
    protected _children: MenuTree[];
    command?: string;
    alt?: string;
    group?: string;
    when?: string;
    /** The orders of the menu items which lead to the submenus */
    submenusOrder?: string;
    constructor(menu?: Menu, 
    /** The location where the menu item will be open from. */
    id?: string | undefined, 
    /** The label of the menu item which leads to the submenu. */
    label?: string | undefined);
    get children(): MenuTree[];
    set children(items: MenuTree[]);
    addChild(node: MenuTree): void;
    get isSubmenu(): boolean;
}
export {};
//# sourceMappingURL=menus-contribution-handler.d.ts.map