/********************************************************************************
 * Copyright (C) 2018 Red Hat, Inc. and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
/// <reference types="@theia/monaco/src/typings/monaco/index" />
import { InputBoxOptions } from '@theia/plugin';
import { interfaces } from '@theia/core/shared/inversify';
import { RPCProtocol } from '../../common/rpc-protocol';
import { QuickOpenMain, TransferInputBox, TransferQuickPickItems, TransferQuickInput } from '../../common/plugin-api-rpc';
import { PickOptions } from '@theia/core/lib/browser';
import { DisposableCollection, Disposable } from '@theia/core/lib/common/disposable';
import { CancellationToken } from '@theia/core/lib/common/cancellation';
import * as theia from '@theia/plugin';
export interface QuickInputSession {
    input: monaco.quickInput.IQuickInput;
    handlesToItems: Map<number, TransferQuickPickItems>;
}
export declare class QuickOpenMainImpl implements QuickOpenMain, Disposable {
    private quickInputService;
    private proxy;
    private delegate;
    private readonly items;
    protected readonly toDispose: DisposableCollection;
    constructor(rpc: RPCProtocol, container: interfaces.Container);
    dispose(): void;
    $show(instance: number, options: PickOptions<TransferQuickPickItems>, token: CancellationToken): Promise<number | number[] | undefined>;
    $setItems(instance: number, items: TransferQuickPickItems[]): Promise<any>;
    $setError(instance: number, error: Error): Promise<void>;
    $input(options: InputBoxOptions, validateInput: boolean, token: CancellationToken): Promise<string | undefined>;
    $showInputBox(options: TransferInputBox, validateInput: boolean): Promise<string | undefined>;
    private sessions;
    $createOrUpdate<T extends theia.QuickPickItem>(params: TransferQuickInput): Promise<void>;
    $hide(): void;
    $dispose(sessionId: number): Promise<void>;
    private convertToQuickInputButtons;
}
//# sourceMappingURL=quick-open-main.d.ts.map