/********************************************************************************
 * Copyright (C) 2019 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { Emitter } from '@theia/core/lib/common/event';
import { EditorPreferences } from '@theia/editor/lib/browser/editor-preferences';
import { ColorRegistry } from '@theia/core/lib/browser/color-registry';
import { ColorApplicationContribution } from '@theia/core/lib/browser/color-application-contribution';
export declare type WebviewThemeType = 'vscode-light' | 'vscode-dark' | 'vscode-high-contrast';
export interface WebviewThemeData {
    readonly activeTheme: WebviewThemeType;
    readonly styles: {
        readonly [key: string]: string | number;
    };
}
export declare class WebviewThemeDataProvider {
    protected readonly onDidChangeThemeDataEmitter: Emitter<void>;
    readonly onDidChangeThemeData: import("@theia/core/lib/common/event").Event<void>;
    protected readonly editorPreferences: EditorPreferences;
    protected readonly colors: ColorRegistry;
    protected readonly colorContribution: ColorApplicationContribution;
    protected themeData: WebviewThemeData | undefined;
    protected readonly editorStyles: Map<"editor.tabSize" | "editor.defaultFormatter" | "editor.insertSpaces" | "editor.detectIndentation" | "editor.trimAutoWhitespace" | "editor.largeFileOptimizations" | "editor.wordBasedSuggestions" | "editor.wordBasedSuggestionsMode" | "editor.semanticHighlighting.enabled" | "editor.stablePeek" | "editor.maxTokenizationLineLength" | "diffEditor.maxComputationTime" | "diffEditor.renderSideBySide" | "diffEditor.ignoreTrimWhitespace" | "diffEditor.renderIndicators" | "diffEditor.codeLens" | "diffEditor.wordWrap" | "editor.acceptSuggestionOnCommitCharacter" | "editor.acceptSuggestionOnEnter" | "editor.accessibilitySupport" | "editor.accessibilityPageSize" | "editor.autoClosingBrackets" | "editor.autoClosingOvertype" | "editor.autoClosingQuotes" | "editor.autoIndent" | "editor.autoSurround" | "editor.ariaLabel" | "editor.automaticLayout" | "editor.codeLens" | "editor.codeLensFontFamily" | "editor.codeLensFontSize" | "editor.colorDecorators" | "editor.comments.insertSpace" | "editor.comments.ignoreEmptyLines" | "editor.contextmenu" | "editor.copyWithSyntaxHighlighting" | "editor.cursorBlinking" | "editor.cursorSmoothCaretAnimation" | "editor.cursorStyle" | "editor.cursorSurroundingLines" | "editor.cursorSurroundingLinesStyle" | "editor.cursorWidth" | "editor.disableLayerHinting" | "editor.disableMonospaceOptimizations" | "editor.dragAndDrop" | "editor.emptySelectionClipboard" | "editor.extraEditorClassName" | "editor.fastScrollSensitivity" | "editor.find.cursorMoveOnType" | "editor.find.seedSearchStringFromSelection" | "editor.find.autoFindInSelection" | "editor.find.globalFindClipboard" | "editor.find.addExtraSpaceOnTop" | "editor.find.loop" | "editor.fixedOverflowWidgets" | "editor.folding" | "editor.foldingStrategy" | "editor.foldingHighlight" | "editor.unfoldOnClickAfterEndOfLine" | "editor.fontFamily" | "editor.fontLigatures" | "editor.fontSize" | "editor.fontWeight" | "editor.formatOnPaste" | "editor.formatOnType" | "editor.glyphMargin" | "editor.gotoLocation.multiple" | "editor.gotoLocation.multipleDefinitions" | "editor.gotoLocation.multipleTypeDefinitions" | "editor.gotoLocation.multipleDeclarations" | "editor.gotoLocation.multipleImplementations" | "editor.gotoLocation.multipleReferences" | "editor.gotoLocation.alternativeDefinitionCommand" | "editor.gotoLocation.alternativeTypeDefinitionCommand" | "editor.gotoLocation.alternativeDeclarationCommand" | "editor.gotoLocation.alternativeImplementationCommand" | "editor.gotoLocation.alternativeReferenceCommand" | "editor.hideCursorInOverviewRuler" | "editor.highlightActiveIndentGuide" | "editor.hover.enabled" | "editor.hover.delay" | "editor.hover.sticky" | "editor.inDiffEditor" | "editor.letterSpacing" | "editor.lightbulb.enabled" | "editor.lineHeight" | "editor.lineNumbers" | "editor.lineNumbersMinChars" | "editor.linkedEditing" | "editor.links" | "editor.matchBrackets" | "editor.minimap.enabled" | "editor.minimap.side" | "editor.minimap.showSlider" | "editor.minimap.scale" | "editor.minimap.renderCharacters" | "editor.minimap.maxColumn" | "editor.mouseStyle" | "editor.mouseWheelScrollSensitivity" | "editor.mouseWheelZoom" | "editor.multiCursorMergeOverlapping" | "editor.multiCursorModifier" | "editor.multiCursorPaste" | "editor.occurrencesHighlight" | "editor.overviewRulerBorder" | "editor.overviewRulerLanes" | "editor.padding.top" | "editor.padding.bottom" | "editor.parameterHints.enabled" | "editor.parameterHints.cycle" | "editor.peekWidgetDefaultFocus" | "editor.definitionLinkOpensInPeek" | "editor.quickSuggestions" | "editor.quickSuggestionsDelay" | "editor.readOnly" | "editor.rename.enablePreview" | "editor.renderControlCharacters" | "editor.renderIndentGuides" | "editor.renderFinalNewline" | "editor.renderLineHighlight" | "editor.renderLineHighlightOnlyWhenFocus" | "editor.renderValidationDecorations" | "editor.renderWhitespace" | "editor.revealHorizontalRightPadding" | "editor.roundedSelection" | "editor.rulers" | "editor.scrollBeyondLastColumn" | "editor.scrollBeyondLastLine" | "editor.scrollPredominantAxis" | "editor.selectionClipboard" | "editor.selectionHighlight" | "editor.selectOnLineNumbers" | "editor.showFoldingControls" | "editor.showUnused" | "editor.showDeprecated" | "editor.inlineHints.enabled" | "editor.inlineHints.fontSize" | "editor.inlineHints.fontFamily" | "editor.snippetSuggestions" | "editor.smartSelect.selectLeadingAndTrailingWhitespace" | "editor.smoothScrolling" | "editor.stickyTabStops" | "editor.stopRenderingLineAfter" | "editor.suggest.insertMode" | "editor.suggest.insertHighlight" | "editor.suggest.filterGraceful" | "editor.suggest.localityBonus" | "editor.suggest.shareSuggestSelections" | "editor.suggest.snippetsPreventQuickSuggestions" | "editor.suggest.showIcons" | "editor.suggest.maxVisibleSuggestions" | "editor.suggest.filteredTypes" | "editor.suggest.showMethods" | "editor.suggest.showFunctions" | "editor.suggest.showConstructors" | "editor.suggest.showFields" | "editor.suggest.showVariables" | "editor.suggest.showClasses" | "editor.suggest.showStructs" | "editor.suggest.showInterfaces" | "editor.suggest.showModules" | "editor.suggest.showProperties" | "editor.suggest.showEvents" | "editor.suggest.showOperators" | "editor.suggest.showUnits" | "editor.suggest.showValues" | "editor.suggest.showConstants" | "editor.suggest.showEnums" | "editor.suggest.showEnumMembers" | "editor.suggest.showKeywords" | "editor.suggest.showWords" | "editor.suggest.showColors" | "editor.suggest.showFiles" | "editor.suggest.showReferences" | "editor.suggest.showCustomcolors" | "editor.suggest.showFolders" | "editor.suggest.showTypeParameters" | "editor.suggest.showSnippets" | "editor.suggest.hideStatusBar" | "editor.suggestFontSize" | "editor.suggestLineHeight" | "editor.suggestOnTriggerCharacters" | "editor.suggestSelection" | "editor.tabCompletion" | "editor.tabIndex" | "editor.unusualLineTerminators" | "editor.useTabStops" | "editor.wordSeparators" | "editor.wordWrap" | "editor.wordWrapBreakAfterCharacters" | "editor.wordWrapBreakBeforeCharacters" | "editor.wordWrapColumn" | "editor.wordWrapOverride1" | "editor.wordWrapOverride2" | "editor.wrappingIndent" | "editor.wrappingStrategy" | "editor.autoSave" | "editor.autoSaveDelay" | "editor.formatOnSave" | "editor.formatOnSaveTimeout" | "editor.history.persistClosedEditors" | "files.eol", string>;
    protected init(): void;
    protected reset(): void;
    getThemeData(): WebviewThemeData;
    protected computeThemeData(): WebviewThemeData;
    protected getActiveTheme(): WebviewThemeType;
}
//# sourceMappingURL=webview-theme-data-provider.d.ts.map