/********************************************************************************
 * Copyright (C) 2020 Red Hat, Inc. and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { AuthenticationExt, Plugin as InternalPlugin } from '../common/plugin-api-rpc';
import { RPCProtocol } from '../common/rpc-protocol';
import { Event } from '@theia/core/lib/common/event';
import * as theia from '@theia/plugin';
import { AuthenticationSession, AuthenticationSessionsChangeEvent } from '../common/plugin-api-rpc-model';
export declare class AuthenticationExtImpl implements AuthenticationExt {
    private proxy;
    private authenticationProviders;
    private _providerIds;
    private _providers;
    private onDidChangeAuthenticationProvidersEmitter;
    readonly onDidChangeAuthenticationProviders: Event<theia.AuthenticationProvidersChangeEvent>;
    private onDidChangeSessionsEmitter;
    readonly onDidChangeSessions: Event<theia.AuthenticationSessionsChangeEvent>;
    constructor(rpc: RPCProtocol);
    getProviderIds(): Promise<ReadonlyArray<string>>;
    get providerIds(): string[];
    get providers(): ReadonlyArray<theia.AuthenticationProviderInformation>;
    getSession(requestingExtension: InternalPlugin, providerId: string, scopes: string[], options: theia.AuthenticationGetSessionOptions & {
        createIfNone: true;
    }): Promise<theia.AuthenticationSession>;
    logout(providerId: string, sessionId: string): Promise<void>;
    registerAuthenticationProvider(provider: theia.AuthenticationProvider): theia.Disposable;
    $login(providerId: string, scopes: string[]): Promise<AuthenticationSession>;
    $logout(providerId: string, sessionId: string): Promise<void>;
    $getSessions(providerId: string): Promise<ReadonlyArray<AuthenticationSession>>;
    $onDidChangeAuthenticationSessions(id: string, label: string, event: AuthenticationSessionsChangeEvent): Promise<void>;
    $onDidChangeAuthenticationProviders(added: theia.AuthenticationProviderInformation[], removed: theia.AuthenticationProviderInformation[]): Promise<void>;
}
//# sourceMappingURL=authentication-ext.d.ts.map