/********************************************************************************
 * Copyright (C) 2020 Red Hat, Inc. and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import * as theia from '@theia/plugin';
import { RPCProtocol } from '../common/rpc-protocol';
import { CommandRegistryImpl } from './command-registry';
import { UriComponents } from '../common/uri-components';
import { Range, CommentOptions } from '../common/plugin-api-rpc-model';
import { DocumentsExtImpl } from './documents';
import { CommentsExt, CommentsMain, Plugin as InternalPlugin } from '../common/plugin-api-rpc';
export declare class CommentsExtImpl implements CommentsExt {
    readonly rpc: RPCProtocol;
    readonly commands: CommandRegistryImpl;
    readonly _documents: DocumentsExtImpl;
    private handle;
    private readonly proxy;
    private readonly commentControllers;
    private readonly commentControllersByExtension;
    constructor(rpc: RPCProtocol, commands: CommandRegistryImpl, _documents: DocumentsExtImpl);
    createCommentController(plugin: InternalPlugin, id: string, label: string): theia.CommentController;
    $createCommentThreadTemplate(commentControllerHandle: number, uriComponents: UriComponents, range: Range): void;
    $updateCommentThreadTemplate(commentControllerHandle: number, threadHandle: number, range: Range): Promise<void>;
    $deleteCommentThread(commentControllerHandle: number, commentThreadHandle: number): Promise<void>;
    $provideCommentingRanges(commentControllerHandle: number, uriComponents: UriComponents, token: theia.CancellationToken): Promise<Range[] | undefined>;
}
export declare class ExtHostCommentThread implements theia.CommentThread, theia.Disposable {
    private proxy;
    private commentController;
    private _id;
    private _uri;
    private _range;
    private _comments;
    private static _handlePool;
    readonly handle: number;
    commentHandle: number;
    private modifications;
    set threadId(id: string);
    get threadId(): string;
    get id(): string;
    get resource(): theia.Uri;
    get uri(): theia.Uri;
    private readonly _onDidUpdateCommentThread;
    readonly onDidUpdateCommentThread: import("@theia/core/lib/common/event").Event<void>;
    set range(range: theia.Range);
    get range(): theia.Range;
    private _label;
    get label(): string | undefined;
    set label(label: string | undefined);
    private _contextValue;
    get contextValue(): string | undefined;
    set contextValue(context: string | undefined);
    get comments(): theia.Comment[];
    set comments(newComments: theia.Comment[]);
    private collapseState?;
    get collapsibleState(): theia.CommentThreadCollapsibleState;
    set collapsibleState(newState: theia.CommentThreadCollapsibleState);
    private localDisposables;
    private _isDisposed;
    get isDisposed(): boolean;
    private commentsMap;
    private acceptInputDisposables;
    constructor(proxy: CommentsMain, commentController: CommentController, _id: string | undefined, _uri: theia.Uri, _range: theia.Range, _comments: theia.Comment[], extensionId: string);
    eventuallyUpdateCommentThread(): void;
    getCommentByUniqueId(uniqueId: number): theia.Comment | undefined;
    dispose(): void;
}
declare class CommentController implements theia.CommentController {
    private extension;
    private proxy;
    private _handle;
    private _id;
    private _label;
    constructor(extension: string, proxy: CommentsMain, _handle: number, _id: string, _label: string);
    private readonly threads;
    readonly commentingRangeProvider?: theia.CommentingRangeProvider;
    get id(): string;
    get label(): string;
    get handle(): number;
    private _options;
    get options(): CommentOptions | undefined;
    set options(options: CommentOptions | undefined);
    createCommentThread(resource: theia.Uri, range: theia.Range, comments: theia.Comment[]): theia.CommentThread;
    $createCommentThreadTemplate(uriComponents: UriComponents, range: Range): ExtHostCommentThread;
    $updateCommentThreadTemplate(threadHandle: number, range: Range): void;
    $deleteCommentThread(threadHandle: number): void;
    getCommentThread(handle: number): ExtHostCommentThread | undefined;
    dispose(): void;
}
export {};
//# sourceMappingURL=comments.d.ts.map