/********************************************************************************
 * Copyright (C) 2020 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
/**
 * **IMPORTANT** this code is running in the plugin host process and should be closed as possible to VS Code counterpart:
 * https://github.com/microsoft/vscode/blob/04c36be045a94fee58e5f8992d3e3fd980294a84/src/vs/workbench/api/common/extHostFileSystem.ts
 * One should be able to diff them to see differences.
 */
import { UriComponents } from '@theia/core/shared/vscode-uri';
import { RPCProtocol } from '../common/rpc-protocol';
import { FileSystemExt } from '../common/plugin-api-rpc';
import * as vscode from '@theia/plugin';
import * as files from '@theia/filesystem/lib/common/files';
import { LanguagesExtImpl } from './languages';
import { BinaryBuffer } from '@theia/core/lib/common/buffer';
export declare class FileSystemExtImpl implements FileSystemExt {
    private _extHostLanguageFeatures;
    private readonly _proxy;
    private readonly _linkProvider;
    private readonly _fsProvider;
    private readonly _usedSchemes;
    private readonly _watches;
    private _linkProviderRegistration?;
    private _handlePool;
    readonly fileSystem: vscode.FileSystem;
    constructor(rpc: RPCProtocol, _extHostLanguageFeatures: LanguagesExtImpl);
    dispose(): void;
    private _registerLinkProviderIfNotYetRegistered;
    registerFileSystemProvider(scheme: string, provider: vscode.FileSystemProvider, options?: {
        isCaseSensitive?: boolean;
        isReadonly?: boolean;
    }): {
        dispose: () => void;
    };
    private static _asIStat;
    $stat(handle: number, resource: UriComponents): Promise<files.Stat>;
    $readdir(handle: number, resource: UriComponents): Promise<[string, files.FileType][]>;
    $readFile(handle: number, resource: UriComponents): Promise<BinaryBuffer>;
    $writeFile(handle: number, resource: UriComponents, content: BinaryBuffer, opts: files.FileWriteOptions): Promise<void>;
    $delete(handle: number, resource: UriComponents, opts: files.FileDeleteOptions): Promise<void>;
    $rename(handle: number, oldUri: UriComponents, newUri: UriComponents, opts: files.FileOverwriteOptions): Promise<void>;
    $copy(handle: number, oldUri: UriComponents, newUri: UriComponents, opts: files.FileOverwriteOptions): Promise<void>;
    $mkdir(handle: number, resource: UriComponents): Promise<void>;
    $watch(handle: number, session: number, resource: UriComponents, opts: files.WatchOptions): void;
    $unwatch(_handle: number, session: number): void;
    $open(handle: number, resource: UriComponents, opts: files.FileOpenOptions): Promise<number>;
    $close(handle: number, fd: number): Promise<void>;
    $read(handle: number, fd: number, pos: number, length: number): Promise<BinaryBuffer>;
    $write(handle: number, fd: number, pos: number, data: BinaryBuffer): Promise<number>;
    private _getFsProvider;
}
//# sourceMappingURL=file-system-ext-impl.d.ts.map